/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.text.AbstractBuildableComponent;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.event.ClickEvent;
import me.lucko.helper.text.event.HoverEvent;
import me.lucko.helper.text.format.TextColor;
import me.lucko.helper.text.format.TextDecoration;
import net.kyori.blizzard.NonNull;
import net.kyori.blizzard.Nullable;

public class ScoreComponent
extends AbstractBuildableComponent<ScoreComponent, Builder> {
    @NonNull
    private final String name;
    @NonNull
    private final String objective;
    @Nullable
    private final String value;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull String name, @NonNull String objective) {
        return new Builder().name(name).objective(objective);
    }

    public static ScoreComponent of(@NonNull String name, @NonNull String objective) {
        return ScoreComponent.of(name, objective, null);
    }

    public static ScoreComponent of(@NonNull String name, @NonNull String objective, @Nullable String value) {
        return ScoreComponent.builder().name(name).objective(objective).value(value).build();
    }

    protected ScoreComponent(@NonNull Builder builder) {
        super(builder);
        this.name = builder.name;
        this.objective = builder.objective;
        this.value = builder.value;
    }

    protected ScoreComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @NonNull String name, @NonNull String objective, @Nullable String value) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
        this.name = name;
        this.objective = objective;
        this.value = value;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public ScoreComponent name(@NonNull String name) {
        return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, (String)Preconditions.checkNotNull((Object)name, (Object)"name"), this.objective, this.value);
    }

    @NonNull
    public String objective() {
        return this.objective;
    }

    @NonNull
    public ScoreComponent objective(@NonNull String objective) {
        return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, (String)Preconditions.checkNotNull((Object)objective, (Object)"objective"), this.value);
    }

    @Nullable
    public String value() {
        return this.value;
    }

    @NonNull
    public ScoreComponent content(@NonNull String value) {
        return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, value);
    }

    @Override
    @NonNull
    public ScoreComponent append(@NonNull Component component) {
        this.detectCycle(component);
        ArrayList<Component> children = new ArrayList<Component>(this.children.size() + 1);
        children.addAll(this.children);
        children.add(component);
        return new ScoreComponent(children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent color(@Nullable TextColor color) {
        return new ScoreComponent(this.children, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (ScoreComponent)super.decoration(decoration, flag);
    }

    @Override
    @NonNull
    public ScoreComponent decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new ScoreComponent(this.children, this.color, this.obfuscated, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
            }
            case ITALIC: {
                return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
            }
            case UNDERLINE: {
                return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
            }
            case STRIKETHROUGH: {
                return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
            }
            case OBFUSCATED: {
                return new ScoreComponent(this.children, this.color, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    @NonNull
    public ScoreComponent clickEvent(@Nullable ClickEvent event) {
        return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent hoverEvent(@Nullable HoverEvent event) {
        if (event != null) {
            this.detectCycle(event.value());
        }
        return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent insertion(@Nullable String insertion) {
        return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent mergeStyle(@NonNull Component that) {
        return new ScoreComponent(this.children, that.color(), that.decoration(TextDecoration.OBFUSCATED), that.decoration(TextDecoration.BOLD), that.decoration(TextDecoration.STRIKETHROUGH), that.decoration(TextDecoration.UNDERLINE), that.decoration(TextDecoration.ITALIC), that.clickEvent(), that.hoverEvent(), that.insertion(), this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent mergeColor(@NonNull Component that) {
        return new ScoreComponent(this.children, that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent mergeDecorations(@NonNull Component that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINE) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINE) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new ScoreComponent(this.children, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent mergeEvents(@NonNull Component that) {
        return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent resetStyle() {
        return new ScoreComponent(this.children, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null, this.name, this.objective, this.value);
    }

    @Override
    @NonNull
    public ScoreComponent copy() {
        return new ScoreComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.name, this.objective, this.value);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof ScoreComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        ScoreComponent that = (ScoreComponent)other;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.objective, (Object)that.objective) && Objects.equal((Object)this.value, (Object)that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.name, this.objective, this.value});
    }

    @Override
    protected void populateToString(@NonNull Objects.ToStringHelper builder) {
        builder.add("name", (Object)this.name).add("objective", (Object)this.objective).add("value", (Object)this.value);
    }

    @Override
    @NonNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractBuildableComponent.AbstractBuilder<ScoreComponent, Builder> {
        @Nullable
        private String name;
        @Nullable
        private String objective;
        @Nullable
        private String value;

        Builder() {
        }

        Builder(@NonNull ScoreComponent component) {
            super(component);
            this.name = component.name();
            this.objective = component.objective();
            this.value = component.value();
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder objective(@NonNull String objective) {
            this.objective = objective;
            return this;
        }

        @NonNull
        public Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        @Override
        @NonNull
        public ScoreComponent build() {
            Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"name must be set");
            Preconditions.checkState((this.objective != null ? 1 : 0) != 0, (Object)"objective must be set");
            return new ScoreComponent(this);
        }
    }
}

