/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.TextUtils;
import me.lucko.helper.text.serializer.ComponentSerializers;
import me.lucko.helper.utils.NmsUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class BukkitTextUtils {
    private static final boolean CHAT_COMPATIBLE = !NmsUtil.getServerVersion().startsWith("v1_7_");
    private static boolean setup = false;
    private static boolean triedAndFailed = false;
    private static Method GET_HANDLE_METHOD;
    private static Field PLAYER_CONNECTION_FIELD;
    private static Method SEND_PACKET_METHOD;
    private static Constructor<?> PACKET_CHAT_CONSTRUCTOR;
    private static Method SERIALIZE_METHOD;

    BukkitTextUtils() {
    }

    private static void setup(Object player) throws Exception {
        Class<?> baseComponentClass;
        Constructor<?>[] packetConstructors;
        Method[] playerConnectionMethods;
        Class<?> craftPlayerClass = player.getClass();
        GET_HANDLE_METHOD = craftPlayerClass.getDeclaredMethod("getHandle", new Class[0]);
        Object handleObject = GET_HANDLE_METHOD.invoke(player, new Object[0]);
        Class<?> handleClass = handleObject.getClass();
        PLAYER_CONNECTION_FIELD = handleClass.getDeclaredField("playerConnection");
        Object playerConnectionObject = PLAYER_CONNECTION_FIELD.get(handleObject);
        for (Method m : playerConnectionMethods = playerConnectionObject.getClass().getDeclaredMethods()) {
            if (!m.getName().equals("sendPacket")) continue;
            SEND_PACKET_METHOD = m;
            break;
        }
        Class<?> packetChatClass = NmsUtil.nmsClass("PacketPlayOutChat");
        for (Constructor<?> c : packetConstructors = packetChatClass.getDeclaredConstructors()) {
            Class<?>[] parameters = c.getParameterTypes();
            if (parameters.length != 1 || !parameters[0].getName().endsWith("IChatBaseComponent")) continue;
            PACKET_CHAT_CONSTRUCTOR = c;
            break;
        }
        Class<?> chatSerializerClass = (baseComponentClass = NmsUtil.nmsClass("IChatBaseComponent")).getClasses().length > 0 ? baseComponentClass.getClasses()[0] : NmsUtil.nmsClass("ChatSerializer");
        SERIALIZE_METHOD = chatSerializerClass.getDeclaredMethod("a", String.class);
    }

    private static synchronized boolean trySetup(Object player) {
        if (setup) {
            return true;
        }
        if (triedAndFailed) {
            return false;
        }
        try {
            BukkitTextUtils.setup(player);
            setup = true;
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            triedAndFailed = true;
            return false;
        }
    }

    private static Object serializeJsonMessage(Player player, Component message) {
        if (!BukkitTextUtils.trySetup(player)) {
            return false;
        }
        try {
            return PACKET_CHAT_CONSTRUCTOR.newInstance(SERIALIZE_METHOD.invoke(null, ComponentSerializers.JSON.serialize(message)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean sendJsonMessage(Player player, Object packet) {
        if (!BukkitTextUtils.trySetup(player)) {
            return false;
        }
        try {
            Object connection = PLAYER_CONNECTION_FIELD.get(GET_HANDLE_METHOD.invoke((Object)player, new Object[0]));
            SEND_PACKET_METHOD.invoke(connection, packet);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void sendJsonMessage(CommandSender sender, Component message) {
        BukkitTextUtils.sendJsonMessage(Collections.singleton(sender), message);
    }

    public static void sendJsonMessage(Iterable<CommandSender> senders, Component message) {
        Object packet = null;
        boolean tried = false;
        String legacy = null;
        for (CommandSender sender : senders) {
            if (CHAT_COMPATIBLE && sender instanceof Player) {
                Player player = (Player)sender;
                if (!tried) {
                    tried = true;
                    packet = BukkitTextUtils.serializeJsonMessage(player, message);
                }
                if (packet != null && BukkitTextUtils.sendJsonMessage(player, packet)) continue;
            }
            if (legacy == null) {
                legacy = TextUtils.toLegacy(message);
            }
            sender.sendMessage(legacy);
        }
    }
}

