/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.terminable.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.lucko.helper.terminable.Terminable;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import me.lucko.helper.terminable.registry.TerminableRegistry;

public class SimpleTerminableRegistry
implements TerminableRegistry {
    private final List<Terminable> terminables = Collections.synchronizedList(new ArrayList());
    private boolean terminated = false;

    @Override
    @Nonnull
    public final <T extends Terminable> T bind(@Nonnull T terminable) {
        Preconditions.checkNotNull(terminable, (Object)"terminable");
        this.terminables.add(terminable);
        return terminable;
    }

    @Override
    @Nonnull
    public <T extends CompositeTerminable> T bindComposite(@Nonnull T terminable) {
        Preconditions.checkNotNull(terminable, (Object)"terminable");
        terminable.setup(this);
        return terminable;
    }

    @Override
    public final boolean terminate() {
        Lists.reverse(this.terminables).forEach(terminable -> {
            try {
                terminable.terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.terminables.clear();
        this.terminated = true;
        return true;
    }

    @Override
    public final boolean hasTerminated() {
        return this.terminated;
    }

    @Override
    public final void cleanup() {
        this.terminables.removeIf(Terminable::hasTerminated);
    }
}

