/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.terminable;

import javax.annotation.Nonnull;
import me.lucko.helper.terminable.Terminable;
import me.lucko.helper.terminable.registry.TerminableRegistry;

public final class Terminables {
    @Nonnull
    public static Terminable combine(Terminable ... terminables) {
        if (terminables.length == 0) {
            return Terminable.EMPTY;
        }
        if (terminables.length == 1) {
            return terminables[0];
        }
        TerminableRegistry registry = TerminableRegistry.create();
        for (Terminable terminable : terminables) {
            terminable.bindWith(registry);
        }
        return registry;
    }

    @Nonnull
    public static Terminable combine(@Nonnull Iterable<Terminable> terminables) {
        TerminableRegistry registry = TerminableRegistry.create();
        for (Terminable terminable : terminables) {
            terminable.bindWith(registry);
        }
        return registry;
    }

    public static void silentlyTerminate(Terminable ... terminables) {
        for (Terminable t : terminables) {
            if (t == null) continue;
            try {
                t.terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void silentlyTerminate(Iterable<? extends Terminable> terminables) {
        for (Terminable terminable : terminables) {
            if (terminable == null) continue;
            try {
                terminable.terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Terminables() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

