/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.terminable;

import javax.annotation.Nonnull;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.utils.Delegates;

@FunctionalInterface
public interface Terminable
extends AutoCloseable {
    public static final Terminable EMPTY = () -> true;

    @Nonnull
    public static Terminable of(@Nonnull Runnable r) {
        return Delegates.runnableToTerminable(r);
    }

    public boolean terminate();

    default public void bindWith(@Nonnull TerminableConsumer consumer) {
        consumer.bind(this);
    }

    default public boolean hasTerminated() {
        return false;
    }

    @Override
    default public void close() {
        this.terminate();
    }
}

