/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.serialize;

import com.flowpowered.math.vector.Vector2i;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import me.lucko.helper.Helper;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.serialize.BlockPosition;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.BlockFace;

public final class ChunkPosition
implements GsonSerializable {
    private final int x;
    private final int z;
    private final String world;

    public static ChunkPosition deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument((boolean)object.has("x"));
        Preconditions.checkArgument((boolean)object.has("z"));
        Preconditions.checkArgument((boolean)object.has("world"));
        int x = object.get("x").getAsInt();
        int z = object.get("z").getAsInt();
        String world = object.get("world").getAsString();
        return ChunkPosition.of(x, z, world);
    }

    public static ChunkPosition of(int x, int z, String world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return new ChunkPosition(x, z, world);
    }

    public static ChunkPosition of(int x, int z, World world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return ChunkPosition.of(x, z, world.getName());
    }

    public static ChunkPosition of(Vector2i vector, String world) {
        Preconditions.checkNotNull((Object)vector, (Object)"vector");
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return ChunkPosition.of(vector.getX(), vector.getY(), world);
    }

    public static ChunkPosition of(Vector2i vector, World world) {
        Preconditions.checkNotNull((Object)vector, (Object)"vector");
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return ChunkPosition.of(vector.getX(), vector.getY(), world);
    }

    public static ChunkPosition of(Chunk location) {
        Preconditions.checkNotNull((Object)location, (Object)"location");
        return ChunkPosition.of(location.getX(), location.getZ(), location.getWorld().getName());
    }

    private ChunkPosition(int x, int z, String world) {
        this.x = x;
        this.z = z;
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String getWorld() {
        return this.world;
    }

    public Vector2i toVector() {
        return new Vector2i(this.x, this.z);
    }

    public synchronized Chunk toChunk() {
        return Helper.world(this.world).get().getChunkAt(this.x, this.z);
    }

    public BlockPosition getBlock(int x, int y, int z) {
        return BlockPosition.of(this.x << 4 | x & 0xF, y, this.z << 4 | z & 0xF, this.world);
    }

    public ChunkPosition getRelative(BlockFace face) {
        Preconditions.checkArgument((face != BlockFace.UP && face != BlockFace.DOWN ? 1 : 0) != 0, (Object)"invalid face");
        return ChunkPosition.of(this.x + face.getModX(), this.z + face.getModZ(), this.world);
    }

    public ChunkPosition getRelative(BlockFace face, int distance) {
        Preconditions.checkArgument((face != BlockFace.UP && face != BlockFace.DOWN ? 1 : 0) != 0, (Object)"invalid face");
        return ChunkPosition.of(this.x + face.getModX() * distance, this.z + face.getModZ() * distance, this.world);
    }

    public ChunkPosition add(Vector2i vector2i) {
        return this.add(vector2i.getX(), vector2i.getY());
    }

    public ChunkPosition add(int x, int z) {
        return ChunkPosition.of(this.x + x, this.z + z, this.world);
    }

    public ChunkPosition subtract(Vector2i vector2i) {
        return this.subtract(vector2i.getX(), vector2i.getY());
    }

    public ChunkPosition subtract(int x, int z) {
        return this.add(-x, -z);
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("x", this.x).add("z", this.z).add("world", this.world).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkPosition)) {
            return false;
        }
        ChunkPosition other = (ChunkPosition)o;
        return this.getX() == other.getX() && this.getZ() == other.getZ() && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getZ();
        result = result * 59 + this.getWorld().hashCode();
        return result;
    }

    public String toString() {
        return "ChunkPosition(x=" + this.getX() + ", z=" + this.getZ() + ", world=" + this.getWorld() + ")";
    }
}

