/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.serialize;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Helper;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.serialize.BlockRegion;
import me.lucko.helper.serialize.ChunkPosition;
import me.lucko.helper.serialize.Position;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public final class BlockPosition
implements GsonSerializable {
    private final int x;
    private final int y;
    private final int z;
    private final String world;
    @Nullable
    private Location bukkitLocation = null;

    public static BlockPosition deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument((boolean)object.has("x"));
        Preconditions.checkArgument((boolean)object.has("y"));
        Preconditions.checkArgument((boolean)object.has("z"));
        Preconditions.checkArgument((boolean)object.has("world"));
        int x = object.get("x").getAsInt();
        int y = object.get("y").getAsInt();
        int z = object.get("z").getAsInt();
        String world = object.get("world").getAsString();
        return BlockPosition.of(x, y, z, world);
    }

    public static BlockPosition of(int x, int y, int z, String world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return new BlockPosition(x, y, z, world);
    }

    public static BlockPosition of(int x, int y, int z, World world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return BlockPosition.of(x, y, z, world.getName());
    }

    public static BlockPosition of(Vector3i vector, String world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return BlockPosition.of(vector.getX(), vector.getY(), vector.getZ(), world);
    }

    public static BlockPosition of(Vector3i vector, World world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return BlockPosition.of(vector.getX(), vector.getY(), vector.getZ(), world);
    }

    public static BlockPosition of(Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location");
        return BlockPosition.of(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getWorld().getName());
    }

    public static BlockPosition of(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block");
        return BlockPosition.of(block.getLocation());
    }

    private BlockPosition(int x, int y, int z, String world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getWorld() {
        return this.world;
    }

    public synchronized Location toLocation() {
        if (this.bukkitLocation == null) {
            this.bukkitLocation = new Location(Helper.worldNullable(this.world), (double)this.x, (double)this.y, (double)this.z);
        }
        return this.bukkitLocation.clone();
    }

    public Vector3i toVector() {
        return new Vector3i(this.x, this.y, this.z);
    }

    public Block toBlock() {
        return this.toLocation().getBlock();
    }

    public Position toPosition() {
        return Position.of((double)this.x, (double)this.y, (double)this.z, this.world);
    }

    public Position toPositionCenter() {
        return Position.of((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, this.world);
    }

    public ChunkPosition toChunk() {
        return ChunkPosition.of(this.x >> 4, this.z >> 4, this.world);
    }

    public BlockPosition getRelative(BlockFace face) {
        Preconditions.checkNotNull((Object)face, (Object)"face");
        return BlockPosition.of(this.x + face.getModX(), this.y + face.getModY(), this.z + face.getModZ(), this.world);
    }

    public BlockPosition getRelative(BlockFace face, int distance) {
        Preconditions.checkNotNull((Object)face, (Object)"face");
        return BlockPosition.of(this.x + face.getModX() * distance, this.y + face.getModY() * distance, this.z + face.getModZ() * distance, this.world);
    }

    public BlockPosition add(Vector3i vector3i) {
        return this.add(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public BlockPosition add(int x, int y, int z) {
        return BlockPosition.of(this.x + x, this.y + y, this.z + z, this.world);
    }

    public BlockPosition subtract(Vector3i vector3i) {
        return this.subtract(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public BlockPosition subtract(int x, int y, int z) {
        return this.add(-x, -y, -z);
    }

    public BlockRegion regionWith(BlockPosition other) {
        Preconditions.checkNotNull((Object)other, (Object)"other");
        return BlockRegion.of(this, other);
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("x", this.x).add("y", this.y).add("z", this.z).add("world", this.world).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockPosition)) {
            return false;
        }
        BlockPosition other = (BlockPosition)o;
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ() && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        result = result * 59 + this.getWorld().hashCode();
        return result;
    }

    public String toString() {
        return "BlockPosition(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", world=" + this.getWorld() + ")";
    }
}

