/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scoreboard;

import com.google.common.base.Preconditions;
import java.util.Set;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

@NonnullByDefault
public interface ScoreboardTeam {
    public String getId();

    public boolean shouldAutoSubscribe();

    public void setAutoSubscribe(boolean var1);

    public String getDisplayName();

    public void setDisplayName(String var1);

    public String getPrefix();

    public void setPrefix(String var1);

    public String getSuffix();

    public void setSuffix(String var1);

    public boolean isAllowFriendlyFire();

    public void setAllowFriendlyFire(boolean var1);

    public boolean isCanSeeFriendlyInvisibles();

    public void setCanSeeFriendlyInvisibles(boolean var1);

    public NameTagVisibility getNameTagVisibility();

    public void setNameTagVisibility(NameTagVisibility var1);

    public CollisionRule getCollisionRule();

    public void setCollisionRule(CollisionRule var1);

    public ChatColor getColor();

    public void setColor(ChatColor var1);

    public boolean addPlayer(String var1);

    public boolean removePlayer(String var1);

    public boolean hasPlayer(String var1);

    default public boolean addPlayer(Player player) {
        return this.addPlayer(((Player)Preconditions.checkNotNull((Object)player, (Object)"player")).getName());
    }

    default public boolean removePlayer(Player player) {
        return this.removePlayer(((Player)Preconditions.checkNotNull((Object)player, (Object)"player")).getName());
    }

    default public boolean hasPlayer(Player player) {
        return this.hasPlayer(((Player)Preconditions.checkNotNull((Object)player, (Object)"player")).getName());
    }

    public Set<String> getPlayers();

    public void subscribe(Player var1);

    public void unsubscribe(Player var1);

    public void unsubscribe(Player var1, boolean var2);

    public void unsubscribeAll();

    public static enum NameTagVisibility {
        ALWAYS("always"),
        NEVER("never"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam");

        private final String protocolName;

        private NameTagVisibility(String protocolName) {
            this.protocolName = protocolName;
        }

        public String getProtocolName() {
            return this.protocolName;
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        NEVER("never"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam");

        private final String protocolName;

        private CollisionRule(String protocolName) {
            this.protocolName = protocolName;
        }

        public String getProtocolName() {
            return this.protocolName;
        }
    }
}

