/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scoreboard;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.scoreboard.GlobalScoreboard;
import me.lucko.helper.scoreboard.PacketScoreboard;
import me.lucko.helper.scoreboard.ScoreboardObjective;
import me.lucko.helper.scoreboard.ScoreboardTeam;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;

@NonnullByDefault
public interface Scoreboard<T extends ScoreboardTeam, O extends ScoreboardObjective> {
    @Nonnull
    public static PacketScoreboard get() {
        return GlobalScoreboard.get();
    }

    public T createTeam(String var1, String var2, boolean var3);

    default public T createTeam(String id, String title) {
        return this.createTeam(id, title, true);
    }

    default public T createTeam(String title, boolean autoSubscribe) {
        return this.createTeam(Long.toHexString(System.nanoTime()), title, autoSubscribe);
    }

    default public T createTeam(String title) {
        return this.createTeam(title, true);
    }

    @Nullable
    public T getTeam(String var1);

    public boolean removeTeam(String var1);

    public O createObjective(String var1, String var2, DisplaySlot var3, boolean var4);

    default public O createObjective(String id, String title, DisplaySlot displaySlot) {
        return this.createObjective(id, title, displaySlot, true);
    }

    default public O createObjective(String title, DisplaySlot displaySlot, boolean autoSubscribe) {
        return this.createObjective(Long.toHexString(System.nanoTime()), title, displaySlot, autoSubscribe);
    }

    default public O createObjective(String title, DisplaySlot displaySlot) {
        return this.createObjective(title, displaySlot, true);
    }

    @Nullable
    public O getObjective(String var1);

    public boolean removeObjective(String var1);

    public T createPlayerTeam(Player var1, String var2, String var3, boolean var4);

    default public T createPlayerTeam(Player player, String id, String title) {
        return this.createPlayerTeam(player, id, title, true);
    }

    default public T createPlayerTeam(Player player, String title, boolean autoSubscribe) {
        return this.createPlayerTeam(player, Long.toHexString(System.nanoTime()), title, autoSubscribe);
    }

    default public T createPlayerTeam(Player player, String title) {
        return this.createPlayerTeam(player, title, true);
    }

    @Nullable
    public T getPlayerTeam(Player var1, String var2);

    public boolean removePlayerTeam(Player var1, String var2);

    public O createPlayerObjective(Player var1, String var2, String var3, DisplaySlot var4, boolean var5);

    default public O createPlayerObjective(Player player, String id, String title, DisplaySlot displaySlot) {
        return this.createPlayerObjective(player, id, title, displaySlot, true);
    }

    default public O createPlayerObjective(Player player, String title, DisplaySlot displaySlot, boolean autoSubscribe) {
        return this.createPlayerObjective(player, Long.toHexString(System.nanoTime()), title, displaySlot, autoSubscribe);
    }

    default public O createPlayerObjective(Player player, String title, DisplaySlot displaySlot) {
        return this.createPlayerObjective(player, title, displaySlot, true);
    }

    @Nullable
    public O getPlayerObjective(Player var1, String var2);

    public boolean removePlayerObjective(Player var1, String var2);
}

