/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scoreboard;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.lucko.helper.Events;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.scoreboard.PacketScoreboardObjective;
import me.lucko.helper.scoreboard.PacketScoreboardTeam;
import me.lucko.helper.scoreboard.Scoreboard;
import me.lucko.helper.utils.Players;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scoreboard.DisplaySlot;

@NonnullByDefault
public class PacketScoreboard
implements Scoreboard<PacketScoreboardTeam, PacketScoreboardObjective> {
    private final ProtocolManager protocolManager;
    private final Map<String, PacketScoreboardTeam> teams = Collections.synchronizedMap(new HashMap());
    private final Map<String, PacketScoreboardObjective> objectives = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Map<String, PacketScoreboardTeam>> playerTeams = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Map<String, PacketScoreboardObjective>> playerObjectives = Collections.synchronizedMap(new HashMap());

    public PacketScoreboard() {
        this(null);
    }

    public PacketScoreboard(@Nullable ExtendedJavaPlugin plugin) {
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        if (plugin != null) {
            Events.subscribe(PlayerJoinEvent.class).handler(this::handlePlayerJoin).bindWith(plugin);
            Events.subscribe(PlayerQuitEvent.class).handler(this::handlePlayerQuit).bindWith(plugin);
        } else {
            Events.subscribe(PlayerJoinEvent.class).handler(this::handlePlayerJoin);
            Events.subscribe(PlayerQuitEvent.class).handler(this::handlePlayerQuit);
        }
    }

    private void handlePlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        for (PacketScoreboardTeam t : this.teams.values()) {
            if (!t.shouldAutoSubscribe()) continue;
            t.subscribe(player);
        }
        for (PacketScoreboardObjective o : this.objectives.values()) {
            if (!o.shouldAutoSubscribe()) continue;
            o.subscribe(player);
        }
    }

    private void handlePlayerQuit(PlayerQuitEvent event) {
        Map<String, PacketScoreboardTeam> playerTeams;
        Player player = event.getPlayer();
        this.teams.values().forEach(t -> {
            t.unsubscribe(player, true);
            t.removePlayer(player);
        });
        this.objectives.values().forEach(o -> o.unsubscribe(player, true));
        Map<String, PacketScoreboardObjective> playerObjectives = this.playerObjectives.remove(player.getUniqueId());
        if (playerObjectives != null) {
            playerObjectives.values().forEach(o -> o.unsubscribe(player, true));
        }
        if ((playerTeams = this.playerTeams.remove(player.getUniqueId())) != null) {
            playerTeams.values().forEach(t -> {
                t.unsubscribe(player, true);
                t.removePlayer(player);
            });
        }
    }

    @Override
    public PacketScoreboardTeam createTeam(String id, String title, boolean autoSubscribe) {
        Preconditions.checkArgument((id.length() <= 16 ? 1 : 0) != 0, (Object)"id cannot be longer than 16 characters");
        Preconditions.checkState((!this.teams.containsKey(id) ? 1 : 0) != 0, (Object)"id already exists");
        PacketScoreboardTeam team = new PacketScoreboardTeam(this, id, title, autoSubscribe);
        if (autoSubscribe) {
            for (Player player : Players.all()) {
                team.subscribe(player);
            }
        }
        this.teams.put(id, team);
        return team;
    }

    @Override
    @Nullable
    public PacketScoreboardTeam getTeam(String id) {
        return this.teams.get(id);
    }

    @Override
    public boolean removeTeam(String id) {
        PacketScoreboardTeam team = this.teams.remove(id);
        if (team == null) {
            return false;
        }
        team.unsubscribeAll();
        return true;
    }

    @Override
    public PacketScoreboardObjective createObjective(String id, String title, DisplaySlot displaySlot, boolean autoSubscribe) {
        Preconditions.checkArgument((id.length() <= 16 ? 1 : 0) != 0, (Object)"id cannot be longer than 16 characters");
        Preconditions.checkState((!this.objectives.containsKey(id) ? 1 : 0) != 0, (Object)"id already exists");
        PacketScoreboardObjective objective = new PacketScoreboardObjective(this, id, title, displaySlot, autoSubscribe);
        if (autoSubscribe) {
            for (Player player : Players.all()) {
                objective.subscribe(player);
            }
        }
        this.objectives.put(id, objective);
        return objective;
    }

    @Override
    @Nullable
    public PacketScoreboardObjective getObjective(String id) {
        return this.objectives.get(id);
    }

    @Override
    public boolean removeObjective(String id) {
        PacketScoreboardObjective objective = this.objectives.remove(id);
        if (objective == null) {
            return false;
        }
        objective.unsubscribeAll();
        return true;
    }

    @Override
    public PacketScoreboardTeam createPlayerTeam(Player player, String id, String title, boolean autoSubscribe) {
        Preconditions.checkArgument((id.length() <= 16 ? 1 : 0) != 0, (Object)"id cannot be longer than 16 characters");
        Map teams = this.playerTeams.computeIfAbsent(player.getUniqueId(), p -> new HashMap());
        Preconditions.checkState((!teams.containsKey(id) ? 1 : 0) != 0, (Object)"id already exists");
        PacketScoreboardTeam team = new PacketScoreboardTeam(this, id, title, autoSubscribe);
        if (autoSubscribe) {
            team.subscribe(player);
        }
        teams.put(id, team);
        return team;
    }

    @Override
    @Nullable
    public PacketScoreboardTeam getPlayerTeam(Player player, String id) {
        Map<String, PacketScoreboardTeam> map = this.playerTeams.get(player.getUniqueId());
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    @Override
    public boolean removePlayerTeam(Player player, String id) {
        Map<String, PacketScoreboardTeam> map = this.playerTeams.get(player.getUniqueId());
        if (map == null) {
            return false;
        }
        PacketScoreboardTeam team = map.remove(id);
        if (team == null) {
            return false;
        }
        team.unsubscribeAll();
        return true;
    }

    @Override
    public PacketScoreboardObjective createPlayerObjective(Player player, String id, String title, DisplaySlot displaySlot, boolean autoSubscribe) {
        Preconditions.checkArgument((id.length() <= 16 ? 1 : 0) != 0, (Object)"id cannot be longer than 16 characters");
        Map objectives = this.playerObjectives.computeIfAbsent(player.getUniqueId(), p -> new HashMap());
        Preconditions.checkState((!objectives.containsKey(id) ? 1 : 0) != 0, (Object)"id already exists");
        PacketScoreboardObjective objective = new PacketScoreboardObjective(this, id, title, displaySlot, autoSubscribe);
        if (autoSubscribe) {
            objective.subscribe(player);
        }
        objectives.put(id, objective);
        return objective;
    }

    @Override
    @Nullable
    public PacketScoreboardObjective getPlayerObjective(Player player, String id) {
        Map<String, PacketScoreboardObjective> map = this.playerObjectives.get(player.getUniqueId());
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    @Override
    public boolean removePlayerObjective(Player player, String id) {
        Map<String, PacketScoreboardObjective> map = this.playerObjectives.get(player.getUniqueId());
        if (map == null) {
            return false;
        }
        PacketScoreboardObjective objective = map.remove(id);
        if (objective == null) {
            return false;
        }
        objective.unsubscribeAll();
        return true;
    }

    void sendPacket(PacketContainer packet, Player player) {
        try {
            this.protocolManager.sendServerPacket(player, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void broadcastPacket(Iterable<Player> players, PacketContainer packet) {
        for (Player player : players) {
            this.sendPacket(packet, player);
        }
    }
}

