/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scheduler.sync;

import java.util.concurrent.CountDownLatch;
import me.lucko.helper.Scheduler;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.promise.ThreadContext;
import me.lucko.helper.scheduler.sync.ServerThreadLock;
import org.bukkit.plugin.Plugin;

final class ServerThreadLockImpl
implements ServerThreadLock {
    private final CountDownLatch obtainedSignal = new CountDownLatch(1);
    private final CountDownLatch doneSignal = new CountDownLatch(1);

    ServerThreadLockImpl() {
        if (ThreadContext.forCurrentThread() == ThreadContext.SYNC) {
            this.obtainedSignal.countDown();
            return;
        }
        Scheduler.bukkit().scheduleSyncDelayedTask((Plugin)LoaderUtils.getPlugin(), this::signal);
        this.await();
    }

    @Override
    public void close() {
        this.doneSignal.countDown();
    }

    private void await() {
        try {
            this.obtainedSignal.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void signal() {
        this.obtainedSignal.countDown();
        try {
            this.doneSignal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

