/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scheduler;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.lucko.helper.Scheduler;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.promise.ThreadContext;
import me.lucko.helper.scheduler.ContextualPromiseBuilder;
import me.lucko.helper.scheduler.ContextualPromiseBuilderImpl;
import me.lucko.helper.scheduler.ContextualTaskBuilder;
import me.lucko.helper.scheduler.ContextualTaskBuilderImpl;
import me.lucko.helper.scheduler.TaskBuilder;
import me.lucko.helper.scheduler.Ticks;

class TaskBuilderImpl
implements TaskBuilder {
    static final TaskBuilder INSTANCE = new TaskBuilderImpl();
    private final TaskBuilder.ThreadContextual sync = new ThreadContextualBuilder(ThreadContext.SYNC);
    private final TaskBuilder.ThreadContextual async = new ThreadContextualBuilder(ThreadContext.ASYNC);

    private TaskBuilderImpl() {
    }

    @Override
    @Nonnull
    public TaskBuilder.ThreadContextual sync() {
        return this.sync;
    }

    @Override
    @Nonnull
    public TaskBuilder.ThreadContextual async() {
        return this.async;
    }

    private static final class DelayedBuilder
    implements TaskBuilder.Delayed {
        private final ThreadContext context;
        private final long delay;

        private DelayedBuilder(ThreadContext context, long delay) {
            this.context = context;
            this.delay = delay;
        }

        @Override
        @Nonnull
        public <T> Promise<T> supply(@Nonnull Supplier<T> supplier) {
            return Scheduler.supplyLater(this.context, supplier, this.delay);
        }

        @Override
        @Nonnull
        public <T> Promise<T> call(@Nonnull Callable<T> callable) {
            return Scheduler.callLater(this.context, callable, this.delay);
        }

        @Override
        @Nonnull
        public Promise<Void> run(@Nonnull Runnable runnable) {
            return Scheduler.runLater(this.context, runnable, this.delay);
        }

        @Override
        @Nonnull
        public ContextualTaskBuilder every(long ticks) {
            return new ContextualTaskBuilderImpl(this.context, this.delay, ticks);
        }

        @Override
        @Nonnull
        public ContextualTaskBuilder every(long duration, TimeUnit unit) {
            return new ContextualTaskBuilderImpl(this.context, this.delay, Ticks.from(duration, unit));
        }
    }

    private static final class ThreadContextualBuilder
    implements TaskBuilder.ThreadContextual {
        private final ThreadContext context;
        private final ContextualPromiseBuilder instant;

        private ThreadContextualBuilder(ThreadContext context) {
            this.context = context;
            this.instant = new ContextualPromiseBuilderImpl(context);
        }

        @Override
        @Nonnull
        public ContextualPromiseBuilder now() {
            return this.instant;
        }

        @Override
        @Nonnull
        public TaskBuilder.Delayed after(long ticks) {
            return new DelayedBuilder(this.context, ticks);
        }

        @Override
        @Nonnull
        public TaskBuilder.Delayed after(long duration, @Nonnull TimeUnit unit) {
            return new DelayedBuilder(this.context, Ticks.from(duration, unit));
        }
    }
}

