/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.promise;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Scheduler;
import me.lucko.helper.interfaces.Delegate;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.promise.ThreadContext;
import org.bukkit.plugin.Plugin;

class HelperPromise<V>
implements Promise<V> {
    private final AtomicBoolean supplied = new AtomicBoolean(false);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    @Nonnull
    private final CompletableFuture<V> fut = new CompletableFuture();

    @Nonnull
    public static <U> HelperPromise<U> empty() {
        return new HelperPromise();
    }

    @Nonnull
    public static <U> HelperPromise<U> completed(@Nullable U value) {
        return new HelperPromise<U>(value);
    }

    @Nonnull
    public static <U> HelperPromise<U> exceptionally(@Nonnull Throwable t) {
        return new HelperPromise(t);
    }

    private HelperPromise() {
    }

    private HelperPromise(@Nullable V v) {
        this.supplied.set(true);
        this.fut.complete(v);
    }

    private HelperPromise(@Nonnull Throwable t) {
        this.supplied.set(true);
        this.fut.completeExceptionally(t);
    }

    private void executeSync(@Nonnull Runnable runnable) {
        if (ThreadContext.forCurrentThread() == ThreadContext.SYNC) {
            Scheduler.wrapRunnable(runnable).run();
        } else {
            Scheduler.sync().execute(runnable);
        }
    }

    private void executeAsync(@Nonnull Runnable runnable) {
        Scheduler.async().execute(runnable);
    }

    private void executeDelayedSync(@Nonnull Runnable runnable, long delay) {
        if (delay <= 0L) {
            this.executeSync(runnable);
        } else {
            Scheduler.bukkit().runTaskLater((Plugin)LoaderUtils.getPlugin(), Scheduler.wrapRunnable(runnable), delay);
        }
    }

    private void executeDelayedAsync(@Nonnull Runnable runnable, long delay) {
        if (delay <= 0L) {
            this.executeAsync(runnable);
        } else {
            Scheduler.bukkit().runTaskLaterAsynchronously((Plugin)LoaderUtils.getPlugin(), Scheduler.wrapRunnable(runnable), delay);
        }
    }

    private boolean complete(V value) {
        return !this.cancelled.get() && this.fut.complete(value);
    }

    private boolean completeExceptionally(@Nonnull Throwable t) {
        return !this.cancelled.get() && this.fut.completeExceptionally(t);
    }

    private void markAsSupplied() {
        if (!this.supplied.compareAndSet(false, true)) {
            throw new IllegalStateException("Promise is already being supplied.");
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled.set(true);
        return this.fut.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.fut.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.fut.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.fut.get();
    }

    @Override
    public V get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.fut.get(timeout, unit);
    }

    @Override
    public V join() {
        return this.fut.join();
    }

    @Override
    public V getNow(V valueIfAbsent) {
        return this.fut.getNow(valueIfAbsent);
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        return this.fut.thenApply(Function.identity());
    }

    @Override
    public boolean terminate() {
        return this.cancel();
    }

    @Override
    public boolean hasTerminated() {
        return this.isCancelled();
    }

    @Override
    @Nonnull
    public Promise<V> supply(@Nullable V value) {
        this.markAsSupplied();
        this.complete(value);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyException(@Nonnull Throwable exception) {
        this.markAsSupplied();
        this.completeExceptionally(exception);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplySync(@Nonnull Supplier<V> supplier) {
        this.markAsSupplied();
        this.executeSync(new SupplyRunnable(supplier));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyAsync(@Nonnull Supplier<V> supplier) {
        this.markAsSupplied();
        this.executeAsync(new SupplyRunnable(supplier));
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedSync(@Nonnull Supplier<V> supplier, long delay) {
        this.markAsSupplied();
        this.executeDelayedSync(new SupplyRunnable(supplier), delay);
        return this;
    }

    @Override
    @Nonnull
    public Promise<V> supplyDelayedAsync(@Nonnull Supplier<V> supplier, long delay) {
        this.markAsSupplied();
        this.executeDelayedAsync(new SupplyRunnable(supplier), delay);
        return this;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplySync(@Nonnull Function<? super V, ? extends U> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeSync(new ApplyRunnable(promise, fn, value));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyAsync(@Nonnull Function<? super V, ? extends U> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeAsync(new ApplyRunnable(promise, fn, value));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedSync(@Nonnull Function<? super V, ? extends U> fn, long delay) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedSync(new ApplyRunnable(promise, fn, value), delay);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenApplyDelayedAsync(@Nonnull Function<? super V, ? extends U> fn, long delay) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedAsync(new ApplyRunnable(promise, fn, value), delay);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeSync(@Nonnull Function<? super V, ? extends Promise<U>> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeSync(new ComposeRunnable(promise, fn, value, true));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeAsync(@Nonnull Function<? super V, ? extends Promise<U>> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeAsync(new ComposeRunnable(promise, fn, value, false));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedSync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delay) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedSync(new ComposeRunnable(promise, fn, value, true), delay);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public <U> Promise<U> thenComposeDelayedAsync(@Nonnull Function<? super V, ? extends Promise<U>> fn, long delay) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t != null) {
                promise.completeExceptionally((Throwable)t);
            } else {
                this.executeDelayedAsync(new ComposeRunnable(promise, fn, value, false), delay);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallySync(@Nonnull Function<Throwable, ? extends V> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeSync(new ExceptionallyRunnable(promise, fn, (Throwable)t));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyAsync(@Nonnull Function<Throwable, ? extends V> fn) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeAsync(new ExceptionallyRunnable(promise, fn, (Throwable)t));
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedSync(@Nonnull Function<Throwable, ? extends V> fn, long delay) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeDelayedSync(new ExceptionallyRunnable(promise, fn, (Throwable)t), delay);
            }
        });
        return promise;
    }

    @Override
    @Nonnull
    public Promise<V> exceptionallyDelayedAsync(@Nonnull Function<Throwable, ? extends V> fn, long delay) {
        HelperPromise promise = HelperPromise.empty();
        this.fut.whenComplete((value, t) -> {
            if (t == null) {
                promise.complete(value);
            } else {
                this.executeDelayedAsync(new ExceptionallyRunnable(promise, fn, (Throwable)t), delay);
            }
        });
        return promise;
    }

    private final class ExceptionallyRunnable<U>
    implements Runnable,
    Delegate<Function> {
        private final HelperPromise<U> promise;
        private final Function<Throwable, ? extends U> function;
        private final Throwable t;

        private ExceptionallyRunnable(HelperPromise<U> promise, Function<Throwable, ? extends U> function, Throwable t) {
            this.promise = promise;
            this.function = function;
            this.t = t;
        }

        @Override
        public Function getDelegate() {
            return this.function;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                ((HelperPromise)this.promise).complete(this.function.apply(this.t));
            }
            catch (Throwable t) {
                Scheduler.EXCEPTION_CONSUMER.accept(t);
                ((HelperPromise)this.promise).completeExceptionally(t);
            }
        }
    }

    private final class ComposeRunnable<U>
    implements Runnable,
    Delegate<Function> {
        private final HelperPromise<U> promise;
        private final Function<? super V, ? extends Promise<U>> function;
        private final V value;
        private final boolean sync;

        private ComposeRunnable(HelperPromise<U> promise, Function<? super V, ? extends Promise<U>> function, V value, boolean sync) {
            this.promise = promise;
            this.function = function;
            this.value = value;
            this.sync = sync;
        }

        @Override
        public Function getDelegate() {
            return this.function;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                Promise<U> p = this.function.apply(this.value);
                if (p == null) {
                    ((HelperPromise)this.promise).complete(null);
                } else if (this.sync) {
                    p.thenAcceptSync(x$0 -> this.promise.complete(x$0));
                } else {
                    p.thenAcceptAsync(x$0 -> this.promise.complete(x$0));
                }
            }
            catch (Throwable t) {
                Scheduler.EXCEPTION_CONSUMER.accept(t);
                ((HelperPromise)this.promise).completeExceptionally(t);
            }
        }
    }

    private final class ApplyRunnable<U>
    implements Runnable,
    Delegate<Function> {
        private final HelperPromise<U> promise;
        private final Function<? super V, ? extends U> function;
        private final V value;

        private ApplyRunnable(HelperPromise<U> promise, Function<? super V, ? extends U> function, V value) {
            this.promise = promise;
            this.function = function;
            this.value = value;
        }

        @Override
        public Function getDelegate() {
            return this.function;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                ((HelperPromise)this.promise).complete(this.function.apply(this.value));
            }
            catch (Throwable t) {
                Scheduler.EXCEPTION_CONSUMER.accept(t);
                ((HelperPromise)this.promise).completeExceptionally(t);
            }
        }
    }

    private final class SupplyRunnable
    implements Runnable,
    Delegate<Supplier<V>> {
        private final Supplier<V> supplier;

        private SupplyRunnable(Supplier<V> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Supplier<V> getDelegate() {
            return this.supplier;
        }

        @Override
        public void run() {
            if (HelperPromise.this.cancelled.get()) {
                return;
            }
            try {
                HelperPromise.this.fut.complete(this.supplier.get());
            }
            catch (Throwable t) {
                Scheduler.EXCEPTION_CONSUMER.accept(t);
                HelperPromise.this.fut.completeExceptionally(t);
            }
        }
    }
}

