/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.profiles.Profile;

final class SimpleProfile
implements Profile {
    @Nonnull
    private final UUID uniqueId;
    @Nullable
    private final String name;

    SimpleProfile(@Nonnull UUID uniqueId, @Nullable String name) {
        this.uniqueId = (UUID)Preconditions.checkNotNull((Object)uniqueId, (Object)"uniqueId");
        this.name = name;
    }

    @Override
    @Nonnull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public long getTimestamp() {
        return -1L;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)o;
        return this.getUniqueId().equals(other.getUniqueId()) && this.getName().equals(other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.name);
    }

    public String toString() {
        return "Profile(uniqueId=" + this.uniqueId + ", name=" + this.name + ")";
    }
}

