/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.plugin.ap;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import me.lucko.helper.plugin.ap.Plugin;
import me.lucko.helper.plugin.ap.PluginDependency;
import org.bukkit.plugin.PluginLoadOrder;
import org.yaml.snakeyaml.Yaml;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"me.lucko.helper.plugin.ap.Plugin", "me.lucko.helper.plugin.ap.PluginDependency"})
public class PluginProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        String[] loadBefore;
        String[] authors;
        PluginLoadOrder order;
        Set<? extends Element> annotatedElements = env.getElementsAnnotatedWith(Plugin.class);
        if (annotatedElements.isEmpty()) {
            return false;
        }
        if (annotatedElements.size() > 1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "More than one @Plugin element found.");
            return false;
        }
        Element element = annotatedElements.iterator().next();
        if (!(element instanceof TypeElement)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Plugin element is not instance of TypeElement");
            return false;
        }
        TypeElement type = (TypeElement)element;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        Plugin annotation = type.getAnnotation(Plugin.class);
        data.put("name", annotation.name());
        String version = annotation.version();
        if (!version.isEmpty()) {
            data.put("version", version);
        } else {
            data.put("version", new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date(System.currentTimeMillis())));
        }
        data.put("main", type.getQualifiedName().toString());
        String description = annotation.description();
        if (!description.isEmpty()) {
            data.put("description", description);
        }
        if ((order = annotation.load()) != PluginLoadOrder.POSTWORLD) {
            data.put("load", order.name());
        }
        if ((authors = annotation.authors()).length == 1) {
            data.put("author", authors[0]);
        } else if (authors.length > 1) {
            data.put("authors", new ArrayList<String>(Arrays.asList(authors)));
        }
        String website = annotation.website();
        if (!website.isEmpty()) {
            data.put("website", website);
        }
        PluginDependency[] depends = annotation.depends();
        ArrayList<String> hard = new ArrayList<String>();
        ArrayList<String> soft = new ArrayList<String>();
        for (PluginDependency depend : depends) {
            if (depend.soft()) {
                soft.add(depend.value());
                continue;
            }
            hard.add(depend.value());
        }
        hard.addAll(Arrays.asList(annotation.hardDepends()));
        soft.addAll(Arrays.asList(annotation.softDepends()));
        if (!hard.isEmpty()) {
            data.put("depend", hard);
        }
        if (!soft.isEmpty()) {
            data.put("softdepend", soft);
        }
        if ((loadBefore = annotation.loadBefore()).length != 0) {
            data.put("loadbefore", new ArrayList<String>(Arrays.asList(loadBefore)));
        }
        try {
            Yaml yaml = new Yaml();
            FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "plugin.yml", new Element[0]);
            try (Writer writer = resource.openWriter();
                 BufferedWriter bw = new BufferedWriter(writer);){
                yaml.dump(data, (Writer)bw);
                bw.flush();
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize plugin descriptor: " + e.getMessage(), e);
        }
    }
}

