/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.lucko.helper.metadata.AbstractMetadataRegistry;
import me.lucko.helper.metadata.MetadataKey;
import me.lucko.helper.metadata.MetadataMap;
import me.lucko.helper.metadata.type.BlockMetadataRegistry;
import me.lucko.helper.metadata.type.EntityMetadataRegistry;
import me.lucko.helper.metadata.type.PlayerMetadataRegistry;
import me.lucko.helper.metadata.type.WorldMetadataRegistry;
import me.lucko.helper.serialize.BlockPosition;
import me.lucko.helper.utils.Players;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

final class StandardMetadataRegistries {
    public static final PlayerMetadataRegistry PLAYER = new PlayerRegistry();
    public static final EntityMetadataRegistry ENTITY = new EntityRegistry();
    public static final BlockMetadataRegistry BLOCK = new BlockRegistry();
    public static final WorldMetadataRegistry WORLD = new WorldRegistry();

    private StandardMetadataRegistries() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static final class WorldRegistry
    extends AbstractMetadataRegistry<UUID>
    implements WorldMetadataRegistry {
        private WorldRegistry() {
        }

        @Override
        @Nonnull
        public MetadataMap provide(@Nonnull World world) {
            Preconditions.checkNotNull((Object)world, (Object)"world");
            return this.provide(world.getUID());
        }

        @Override
        @Nonnull
        public Optional<MetadataMap> get(@Nonnull World world) {
            Preconditions.checkNotNull((Object)world, (Object)"world");
            return this.get(world.getUID());
        }

        @Override
        @Nonnull
        public <K> Map<World, K> getAllWithKey(@Nonnull MetadataKey<K> key) {
            Preconditions.checkNotNull(key, (Object)"key");
            ImmutableMap.Builder ret = ImmutableMap.builder();
            this.cache.asMap().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
                World world = Bukkit.getWorld((UUID)uuid);
                if (world != null) {
                    ret.put((Object)world, t);
                }
            }));
            return ret.build();
        }
    }

    private static final class BlockRegistry
    extends AbstractMetadataRegistry<BlockPosition>
    implements BlockMetadataRegistry {
        private BlockRegistry() {
        }

        @Override
        @Nonnull
        public MetadataMap provide(@Nonnull Block block) {
            Preconditions.checkNotNull((Object)block, (Object)"block");
            return this.provide(BlockPosition.of(block));
        }

        @Override
        @Nonnull
        public Optional<MetadataMap> get(@Nonnull Block block) {
            Preconditions.checkNotNull((Object)block, (Object)"block");
            return this.get(BlockPosition.of(block));
        }

        @Override
        @Nonnull
        public <K> Map<BlockPosition, K> getAllWithKey(@Nonnull MetadataKey<K> key) {
            Preconditions.checkNotNull(key, (Object)"key");
            ImmutableMap.Builder ret = ImmutableMap.builder();
            this.cache.asMap().forEach((pos, map) -> map.get(key).ifPresent(t -> ret.put(pos, t)));
            return ret.build();
        }
    }

    private static final class EntityRegistry
    extends AbstractMetadataRegistry<UUID>
    implements EntityMetadataRegistry {
        private EntityRegistry() {
        }

        @Override
        @Nonnull
        public MetadataMap provide(@Nonnull Entity entity) {
            Preconditions.checkNotNull((Object)entity, (Object)"entity");
            return this.provide(entity.getUniqueId());
        }

        @Override
        @Nonnull
        public Optional<MetadataMap> get(@Nonnull Entity entity) {
            Preconditions.checkNotNull((Object)entity, (Object)"entity");
            return this.get(entity.getUniqueId());
        }

        @Override
        @Nonnull
        public <K> Map<Entity, K> getAllWithKey(@Nonnull MetadataKey<K> key) {
            Preconditions.checkNotNull(key, (Object)"key");
            ImmutableMap.Builder ret = ImmutableMap.builder();
            this.cache.asMap().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity != null) {
                    ret.put((Object)entity, t);
                }
            }));
            return ret.build();
        }
    }

    private static final class PlayerRegistry
    extends AbstractMetadataRegistry<UUID>
    implements PlayerMetadataRegistry {
        private PlayerRegistry() {
        }

        @Override
        @Nonnull
        public MetadataMap provide(@Nonnull Player player) {
            Preconditions.checkNotNull((Object)player, (Object)"player");
            return this.provide(player.getUniqueId());
        }

        @Override
        @Nonnull
        public Optional<MetadataMap> get(@Nonnull Player player) {
            Preconditions.checkNotNull((Object)player, (Object)"player");
            return this.get(player.getUniqueId());
        }

        @Override
        @Nonnull
        public <K> Map<Player, K> getAllWithKey(@Nonnull MetadataKey<K> key) {
            Preconditions.checkNotNull(key, (Object)"key");
            ImmutableMap.Builder ret = ImmutableMap.builder();
            this.cache.asMap().forEach((uuid, map) -> map.get(key).ifPresent(t -> {
                Player player = Players.getNullable(uuid);
                if (player != null) {
                    ret.put((Object)player, t);
                }
            }));
            return ret.build();
        }
    }
}

