/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.scheme;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import me.lucko.helper.menu.Gui;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.scheme.MenuPopulator;
import me.lucko.helper.menu.scheme.SchemeMapping;
import me.lucko.helper.menu.scheme.StandardSchemeMappings;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public class MenuScheme {
    private static final boolean[] EMPTY_MASK = new boolean[]{false, false, false, false, false, false, false, false, false};
    private static final int[] EMPTY_SCHEME = new int[0];
    private final SchemeMapping mapping;
    private final List<boolean[]> maskRows;
    private final List<int[]> schemeRows;

    public MenuScheme(@Nullable SchemeMapping mapping) {
        this.mapping = mapping == null ? StandardSchemeMappings.EMPTY : mapping;
        this.maskRows = new ArrayList<boolean[]>();
        this.schemeRows = new ArrayList<int[]>();
    }

    public MenuScheme() {
        this((SchemeMapping)null);
    }

    private MenuScheme(MenuScheme other) {
        this.mapping = other.mapping.copy();
        this.maskRows = new ArrayList<boolean[]>();
        for (Object[] arr : other.maskRows) {
            this.maskRows.add(Arrays.copyOf(arr, arr.length));
        }
        this.schemeRows = new ArrayList<int[]>();
        Iterator<Object[]> iterator = other.schemeRows.iterator();
        while (iterator.hasNext()) {
            Object[] arr;
            arr = (int[])iterator.next();
            this.schemeRows.add(Arrays.copyOf((int[])arr, arr.length));
        }
    }

    public MenuScheme mask(String s) {
        char[] chars = s.replace(" ", "").toCharArray();
        if (chars.length != 9) {
            throw new IllegalArgumentException("invalid mask: " + s);
        }
        boolean[] ret = new boolean[9];
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '1' || c == 't') {
                ret[i] = true;
                continue;
            }
            if (c == '0' || c == 'f' || c == 'x') {
                ret[i] = false;
                continue;
            }
            throw new IllegalArgumentException("invalid mask character: " + c);
        }
        this.maskRows.add(ret);
        return this;
    }

    public MenuScheme masks(String ... strings) {
        for (String s : strings) {
            this.mask(s);
        }
        return this;
    }

    public MenuScheme maskEmpty(int lines) {
        for (int i = 0; i < lines; ++i) {
            this.maskRows.add(EMPTY_MASK);
            this.schemeRows.add(EMPTY_SCHEME);
        }
        return this;
    }

    public MenuScheme scheme(int ... schemeIds) {
        for (int schemeId : schemeIds) {
            if (this.mapping.hasMappingFor(schemeId)) continue;
            throw new IllegalArgumentException("mapping does not contain value for id: " + schemeId);
        }
        this.schemeRows.add(schemeIds);
        return this;
    }

    public void apply(Gui gui) {
        int invIndex = 0;
        for (int i = 0; i < this.maskRows.size(); ++i) {
            boolean[] mask = this.maskRows.get(i);
            int[] scheme = this.schemeRows.get(i);
            int schemeIndex = 0;
            for (boolean b : mask) {
                int index = invIndex++;
                if (!b) continue;
                int schemeMappingId = scheme[schemeIndex++];
                this.mapping.get(schemeMappingId).ifPresent(item -> gui.setItem(index, (Item)item));
            }
        }
    }

    public List<Integer> getMaskedIndexes() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int invIndex = 0;
        for (boolean[] mask : this.maskRows) {
            for (boolean b : mask) {
                int index = invIndex++;
                if (!b) continue;
                ret.add(index);
            }
        }
        return ret;
    }

    public ImmutableList<Integer> getMaskedIndexesImmutable() {
        return ImmutableList.copyOf(this.getMaskedIndexes());
    }

    public MenuPopulator newPopulator(Gui gui) {
        return new MenuPopulator(gui, this);
    }

    public MenuScheme copy() {
        return new MenuScheme(this);
    }
}

