/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.scheme;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import me.lucko.helper.menu.Gui;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.Slot;
import me.lucko.helper.menu.scheme.MenuScheme;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public class MenuPopulator {
    private final Gui gui;
    private final ImmutableList<Integer> slots;
    protected List<Integer> remainingSlots;

    public MenuPopulator(Gui gui, MenuScheme scheme) {
        Preconditions.checkNotNull((Object)gui, (Object)"gui");
        Preconditions.checkNotNull((Object)scheme, (Object)"scheme");
        this.remainingSlots = scheme.getMaskedIndexes();
        Preconditions.checkArgument((this.remainingSlots.size() > 0 ? 1 : 0) != 0, (Object)"no slots in scheme");
        this.gui = gui;
        this.slots = ImmutableList.copyOf(this.remainingSlots);
    }

    public MenuPopulator(Gui gui, List<Integer> slots) {
        Preconditions.checkNotNull((Object)gui, (Object)"gui");
        Preconditions.checkNotNull(slots, (Object)"slots");
        Preconditions.checkArgument((slots.size() > 0 ? 1 : 0) != 0, (Object)"no slots in list");
        this.gui = gui;
        this.slots = ImmutableList.copyOf(slots);
        this.remainingSlots = new ArrayList<Integer>((Collection<Integer>)this.slots);
    }

    private MenuPopulator(MenuPopulator other) {
        this.gui = other.gui;
        this.slots = other.slots;
        this.remainingSlots = new ArrayList<Integer>((Collection<Integer>)this.slots);
    }

    public ImmutableList<Integer> getSlots() {
        return this.slots;
    }

    public void reset() {
        this.remainingSlots = new ArrayList<Integer>((Collection<Integer>)this.slots);
    }

    public MenuPopulator consume(Consumer<Slot> action) {
        if (this.tryConsume(action)) {
            return this;
        }
        throw new IllegalStateException("No more slots");
    }

    public MenuPopulator consumeIfSpace(Consumer<Slot> action) {
        this.tryConsume(action);
        return this;
    }

    public boolean tryConsume(Consumer<Slot> action) {
        Preconditions.checkNotNull(action, (Object)"action");
        if (this.remainingSlots.isEmpty()) {
            return false;
        }
        int slot = this.remainingSlots.remove(0);
        action.accept(this.gui.getSlot(slot));
        return true;
    }

    public MenuPopulator accept(Item item) {
        return this.consume(s -> s.applyFromItem(item));
    }

    public MenuPopulator acceptIfSpace(Item item) {
        return this.consumeIfSpace(s -> s.applyFromItem(item));
    }

    public boolean placeIfSpace(Item item) {
        return this.tryConsume(s -> s.applyFromItem(item));
    }

    public int getRemainingSpace() {
        return this.remainingSlots.size();
    }

    public boolean hasSpace() {
        return !this.remainingSlots.isEmpty();
    }

    public MenuPopulator copy() {
        return new MenuPopulator(this);
    }
}

