/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.paginated;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import me.lucko.helper.item.ItemStackBuilder;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.paginated.PageInfo;
import me.lucko.helper.menu.paginated.PaginatedGui;
import me.lucko.helper.menu.scheme.MenuScheme;
import me.lucko.helper.menu.scheme.StandardSchemeMappings;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@NonnullByDefault
public class PaginatedGuiBuilder {
    public static final int DEFAULT_LINES = 6;
    public static final int DEFAULT_NEXT_PAGE_SLOT = new MenuScheme().maskEmpty(5).mask("000000010").getMaskedIndexes().get(0);
    public static final int DEFAULT_PREVIOUS_PAGE_SLOT = new MenuScheme().maskEmpty(5).mask("010000000").getMaskedIndexes().get(0);
    public static final List<Integer> DEFAULT_ITEM_SLOTS = new MenuScheme().mask("011111110").mask("011111110").mask("011111110").mask("011111110").mask("011111110").getMaskedIndexesImmutable();
    public static final MenuScheme DEFAULT_SCHEME = new MenuScheme(StandardSchemeMappings.STAINED_GLASS).mask("100000001").mask("100000001").mask("100000001").mask("100000001").mask("100000001").mask("100000001").scheme(3, 3).scheme(3, 3).scheme(3, 3).scheme(3, 3).scheme(3, 3).scheme(3, 3);
    public static final Function<PageInfo, ItemStack> DEFAULT_NEXT_PAGE_ITEM = pageInfo -> ItemStackBuilder.of(Material.ARROW).name("&b&m--&b>").lore("&fSwitch to the next page.").lore("").lore("&7Currently viewing page &b" + pageInfo.getCurrent() + "&7/&b" + pageInfo.getSize()).build();
    public static final Function<PageInfo, ItemStack> DEFAULT_PREVIOUS_PAGE_ITEM = pageInfo -> ItemStackBuilder.of(Material.ARROW).name("&b<&b&m--").lore("&fSwitch to the previous page.").lore("").lore("&7Currently viewing page &b" + pageInfo.getCurrent() + "&7/&b" + pageInfo.getSize()).build();
    private int lines = 6;
    private String title;
    private List<Integer> itemSlots = DEFAULT_ITEM_SLOTS;
    private int nextPageSlot = DEFAULT_NEXT_PAGE_SLOT;
    private int previousPageSlot = DEFAULT_PREVIOUS_PAGE_SLOT;
    private MenuScheme scheme = DEFAULT_SCHEME;
    private Function<PageInfo, ItemStack> nextPageItem = DEFAULT_NEXT_PAGE_ITEM;
    private Function<PageInfo, ItemStack> previousPageItem = DEFAULT_PREVIOUS_PAGE_ITEM;

    public static PaginatedGuiBuilder create() {
        return new PaginatedGuiBuilder();
    }

    private PaginatedGuiBuilder() {
    }

    public PaginatedGuiBuilder copy() {
        PaginatedGuiBuilder copy = new PaginatedGuiBuilder();
        copy.lines = this.lines;
        copy.title = this.title;
        copy.itemSlots = this.itemSlots;
        copy.nextPageSlot = this.nextPageSlot;
        copy.previousPageSlot = this.previousPageSlot;
        copy.scheme = this.scheme.copy();
        copy.nextPageItem = this.nextPageItem;
        copy.previousPageItem = this.previousPageItem;
        return copy;
    }

    public PaginatedGuiBuilder lines(int lines) {
        this.lines = lines;
        return this;
    }

    public PaginatedGuiBuilder title(String title) {
        this.title = title;
        return this;
    }

    public PaginatedGuiBuilder itemSlots(List<Integer> itemSlots) {
        this.itemSlots = ImmutableList.copyOf(itemSlots);
        return this;
    }

    public PaginatedGuiBuilder nextPageSlot(int nextPageSlot) {
        this.nextPageSlot = nextPageSlot;
        return this;
    }

    public PaginatedGuiBuilder previousPageSlot(int previousPageSlot) {
        this.previousPageSlot = previousPageSlot;
        return this;
    }

    public PaginatedGuiBuilder scheme(MenuScheme scheme) {
        this.scheme = (MenuScheme)Preconditions.checkNotNull((Object)scheme, (Object)"scheme");
        return this;
    }

    public PaginatedGuiBuilder nextPageItem(Function<PageInfo, ItemStack> nextPageItem) {
        this.nextPageItem = (Function)Preconditions.checkNotNull(nextPageItem, (Object)"nextPageItem");
        return this;
    }

    public PaginatedGuiBuilder previousPageItem(Function<PageInfo, ItemStack> previousPageItem) {
        this.previousPageItem = (Function)Preconditions.checkNotNull(previousPageItem, (Object)"previousPageItem");
        return this;
    }

    public int getLines() {
        return this.lines;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Integer> getItemSlots() {
        return this.itemSlots;
    }

    public int getNextPageSlot() {
        return this.nextPageSlot;
    }

    public int getPreviousPageSlot() {
        return this.previousPageSlot;
    }

    public MenuScheme getScheme() {
        return this.scheme;
    }

    public Function<PageInfo, ItemStack> getNextPageItem() {
        return this.nextPageItem;
    }

    public Function<PageInfo, ItemStack> getPreviousPageItem() {
        return this.previousPageItem;
    }

    public PaginatedGui build(Player player, Function<PaginatedGui, List<Item>> content) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull(content, (Object)"content");
        Preconditions.checkNotNull((Object)this.lines, (Object)"lines");
        Preconditions.checkNotNull((Object)this.title, (Object)"title");
        Preconditions.checkNotNull(this.itemSlots, (Object)"itemSlots");
        Preconditions.checkNotNull((Object)this.nextPageSlot, (Object)"nextPageSlot");
        Preconditions.checkNotNull((Object)this.previousPageSlot, (Object)"previousPageSlot");
        Preconditions.checkNotNull((Object)this.scheme, (Object)"scheme");
        Preconditions.checkNotNull(this.nextPageItem, (Object)"nextPageItem");
        Preconditions.checkNotNull(this.previousPageItem, (Object)"previousPageItem");
        return new PaginatedGui(content, player, this);
    }
}

