/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.utils.Delegates;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class Item {
    private final Map<ClickType, Consumer<InventoryClickEvent>> handlers;
    private final ItemStack itemStack;

    @Nonnull
    public static Builder builder(@Nonnull ItemStack itemStack) {
        return new Builder(itemStack);
    }

    public Item(@Nonnull Map<ClickType, Consumer<InventoryClickEvent>> handlers, @Nonnull ItemStack itemStack) {
        this.handlers = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(handlers, (Object)"handlers")));
        this.itemStack = (ItemStack)Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack");
    }

    @Nonnull
    public Map<ClickType, Consumer<InventoryClickEvent>> getHandlers() {
        return this.handlers;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Nonnull
    public static Consumer<InventoryClickEvent> transformRunnable(@Nonnull Runnable runnable) {
        return Delegates.runnableToConsumer(runnable);
    }

    public static final class Builder {
        private final ItemStack itemStack;
        private final Map<ClickType, Consumer<InventoryClickEvent>> handlers;

        private Builder(@Nonnull ItemStack itemStack) {
            this.itemStack = (ItemStack)Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack");
            this.handlers = new HashMap<ClickType, Consumer<InventoryClickEvent>>();
        }

        @Nonnull
        public Builder bind(@Nonnull ClickType type, @Nullable Consumer<InventoryClickEvent> handler) {
            Preconditions.checkNotNull((Object)type, (Object)"type");
            if (handler != null) {
                this.handlers.put(type, handler);
            } else {
                this.handlers.remove(type);
            }
            return this;
        }

        @Nonnull
        public Builder bind(@Nonnull ClickType type, @Nullable Runnable handler) {
            Preconditions.checkNotNull((Object)type, (Object)"type");
            if (handler != null) {
                this.handlers.put(type, Item.transformRunnable(handler));
            } else {
                this.handlers.remove(type);
            }
            return this;
        }

        @Nonnull
        public Builder bind(@Nullable Consumer<InventoryClickEvent> handler, ClickType ... types) {
            for (ClickType type : types) {
                this.bind(type, handler);
            }
            return this;
        }

        @Nonnull
        public Builder bind(@Nullable Runnable handler, ClickType ... types) {
            for (ClickType type : types) {
                this.bind(type, handler);
            }
            return this;
        }

        @Nonnull
        public <T extends Runnable> Builder bindAllRunnables(@Nonnull Iterable<Map.Entry<ClickType, T>> handlers) {
            Preconditions.checkNotNull(handlers, (Object)"handlers");
            for (Map.Entry<ClickType, T> handler : handlers) {
                this.bind(handler.getKey(), (Runnable)handler.getValue());
            }
            return this;
        }

        @Nonnull
        public <T extends Consumer<InventoryClickEvent>> Builder bindAllConsumers(@Nonnull Iterable<Map.Entry<ClickType, T>> handlers) {
            Preconditions.checkNotNull(handlers, (Object)"handlers");
            for (Map.Entry<ClickType, T> handler : handlers) {
                this.bind(handler.getKey(), (Consumer)handler.getValue());
            }
            return this;
        }

        @Nonnull
        public Item build() {
            return new Item(this.handlers, this.itemStack);
        }
    }
}

