/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.maven;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.maven.MavenLibrary;
import me.lucko.helper.utils.Log;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public final class LibraryLoader {
    private static final Method ADD_URL_METHOD;

    public static void loadAll(Object object) {
        LibraryLoader.loadAll(object.getClass());
    }

    public static void loadAll(Class<?> clazz) {
        MavenLibrary[] libs = (MavenLibrary[])clazz.getDeclaredAnnotationsByType(MavenLibrary.class);
        if (libs == null) {
            return;
        }
        for (MavenLibrary lib : libs) {
            LibraryLoader.load(lib.groupId(), lib.artifactId(), lib.version(), lib.repo().url());
        }
    }

    public static void load(String groupId, String artifactId, String version) {
        LibraryLoader.load(groupId, artifactId, version, "http://repo1.maven.org/maven2");
    }

    public static void load(String groupId, String artifactId, String version, String repoUrl) {
        LibraryLoader.load(new Dependency(groupId, artifactId, version, repoUrl));
    }

    public static void load(Dependency d) {
        Log.info(String.format("Loading dependency %s:%s:%s from %s", d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getRepoUrl()));
        String name = d.getArtifactId() + "-" + d.getVersion();
        File saveLocation = new File(LibraryLoader.getLibFolder(), name + ".jar");
        if (!saveLocation.exists()) {
            try {
                Log.info("Dependency '" + name + "' is not already in the libraries folder. Attempting to download...");
                URL url = d.getUrl();
                try (InputStream is = url.openStream();){
                    Files.copy(is, saveLocation.toPath(), new CopyOption[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Log.info("Dependency '" + name + "' successfully downloaded.");
        }
        if (!saveLocation.exists()) {
            throw new RuntimeException("Unable to download dependency: " + d.toString());
        }
        URLClassLoader classLoader = (URLClassLoader)LoaderUtils.getPlugin().getClass().getClassLoader();
        try {
            ADD_URL_METHOD.invoke((Object)classLoader, saveLocation.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load dependency: " + saveLocation.toString(), e);
        }
        Log.info("Loaded dependency '" + name + "' successfully.");
    }

    private static File getLibFolder() {
        File pluginDataFolder = LoaderUtils.getPlugin().getDataFolder();
        File pluginsDir = pluginDataFolder.getParentFile();
        File helperDir = new File(pluginsDir, "helper");
        File libs = new File(helperDir, "libraries");
        libs.mkdirs();
        return libs;
    }

    static {
        try {
            ADD_URL_METHOD = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            ADD_URL_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @NonnullByDefault
    public static final class Dependency {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String repoUrl;

        public Dependency(String groupId, String artifactId, String version, String repoUrl) {
            this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId");
            this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId, (Object)"artifactId");
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            this.repoUrl = (String)Preconditions.checkNotNull((Object)repoUrl, (Object)"repoUrl");
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRepoUrl() {
            return this.repoUrl;
        }

        public URL getUrl() throws MalformedURLException {
            String repo = this.repoUrl;
            if (!repo.endsWith("/")) {
                repo = repo + "/";
            }
            repo = repo + "%s/%s/%s/%s-%s.jar";
            String url = String.format(repo, this.groupId.replace(".", "/"), this.artifactId, this.version, this.artifactId, this.version);
            return new URL(url);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            return this.getGroupId().equals(other.getGroupId()) && this.getArtifactId().equals(other.getArtifactId()) && this.getVersion().equals(other.getVersion()) && this.getRepoUrl().equals(other.getRepoUrl());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getGroupId().hashCode();
            result = result * 59 + this.getArtifactId().hashCode();
            result = result * 59 + this.getVersion().hashCode();
            result = result * 59 + this.getRepoUrl().hashCode();
            return result;
        }

        public String toString() {
            return "LibraryLoader.Dependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", repoUrl=" + this.getRepoUrl() + ")";
        }
    }
}

