/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.internal;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nonnull;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializerCollection;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializers;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.gson.GsonSerializableConfigurateProxy;
import me.lucko.helper.gson.configurate.JsonArraySerializer;
import me.lucko.helper.gson.configurate.JsonNullSerializer;
import me.lucko.helper.gson.configurate.JsonObjectSerializer;
import me.lucko.helper.gson.configurate.JsonPrimitiveSerializer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public final class LoaderUtils {
    private static JavaPlugin plugin = null;
    private static Thread mainThread = null;

    @Nonnull
    public static synchronized JavaPlugin getPlugin() {
        if (plugin == null) {
            plugin = JavaPlugin.getProvidingPlugin(LoaderUtils.class);
            String packageName = LoaderUtils.class.getPackage().getName();
            packageName = packageName.substring(0, packageName.length() - ".internal".length());
            Bukkit.getLogger().info("[helper] helper (" + packageName + ") bound to plugin " + plugin.getName() + " - " + plugin.getClass().getName());
            LoaderUtils.setup();
        }
        return plugin;
    }

    @Nonnull
    public static synchronized Thread getMainThread() {
        if (mainThread == null && Bukkit.getServer().isPrimaryThread()) {
            mainThread = Thread.currentThread();
        }
        return mainThread;
    }

    private static void setup() {
        LoaderUtils.getMainThread();
        TypeSerializerCollection defs = TypeSerializers.getDefaultSerializers();
        defs.registerType(TypeToken.of(JsonArray.class), JsonArraySerializer.INSTANCE);
        defs.registerType(TypeToken.of(JsonObject.class), JsonObjectSerializer.INSTANCE);
        defs.registerType(TypeToken.of(JsonPrimitive.class), JsonPrimitiveSerializer.INSTANCE);
        defs.registerType(TypeToken.of(JsonNull.class), JsonNullSerializer.INSTANCE);
        defs.registerType(TypeToken.of(GsonSerializable.class), GsonSerializableConfigurateProxy.INSTANCE);
    }

    private LoaderUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

