/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import javax.annotation.Nonnull;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import me.lucko.helper.gson.GsonSerializable;

public final class GsonSerializableConfigurateProxy
implements TypeSerializer<GsonSerializable> {
    private static final TypeToken<JsonElement> JSON_ELEMENT_TYPE = TypeToken.of(JsonElement.class);
    @Nonnull
    public static final GsonSerializableConfigurateProxy INSTANCE = new GsonSerializableConfigurateProxy();

    private GsonSerializableConfigurateProxy() {
    }

    @Override
    public GsonSerializable deserialize(TypeToken<?> type, ConfigurationNode node) throws ObjectMappingException {
        return GsonSerializable.deserializeRaw(type.getRawType(), (JsonElement)node.getValue(JSON_ELEMENT_TYPE, JsonNull.INSTANCE));
    }

    @Override
    public void serialize(TypeToken<?> type, GsonSerializable s, ConfigurationNode node) throws ObjectMappingException {
        node.setValue(JSON_ELEMENT_TYPE, s.serialize());
    }
}

