/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import me.lucko.helper.gson.GsonSerializable;

public final class GsonSerializableAdapterFactory
implements TypeAdapterFactory {
    @Nonnull
    public static final GsonSerializableAdapterFactory INSTANCE = new GsonSerializableAdapterFactory();

    private GsonSerializableAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        Class clazz = type.getRawType();
        final Method deserializeMethod = GsonSerializable.getDeserializeMethod(clazz);
        if (deserializeMethod == null) {
            return null;
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter writer, T t) throws IOException {
                GsonSerializable serializable = (GsonSerializable)t;
                gson.toJson(serializable.serialize(), writer);
            }

            public T read(JsonReader reader) throws IOException {
                JsonElement element = (JsonElement)gson.fromJson(reader, JsonElement.class);
                try {
                    return deserializeMethod.invoke(null, element);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
    }
}

