/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import java.io.Reader;
import javax.annotation.Nonnull;
import me.lucko.helper.gson.GsonSerializableAdapterFactory;

public final class GsonProvider {
    private static final Gson STANDARD = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)GsonSerializableAdapterFactory.INSTANCE).serializeNulls().create();
    private static final Gson PRETTY_PRINT = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)GsonSerializableAdapterFactory.INSTANCE).serializeNulls().setPrettyPrinting().create();

    @Nonnull
    public static Gson get() {
        return STANDARD;
    }

    @Nonnull
    public static Gson getPrettyPrinting() {
        return PRETTY_PRINT;
    }

    @Nonnull
    public static JsonObject readObject(@Nonnull Reader reader) {
        return (JsonObject)Preconditions.checkNotNull((Object)GsonProvider.get().fromJson(reader, JsonObject.class));
    }

    @Nonnull
    public static JsonObject readObject(@Nonnull String s) {
        return (JsonObject)Preconditions.checkNotNull((Object)GsonProvider.get().fromJson(s, JsonObject.class));
    }

    public static void writeObject(@Nonnull Appendable writer, @Nonnull JsonObject object) {
        GsonProvider.get().toJson((JsonElement)object, writer);
    }

    public static void writeObjectPretty(@Nonnull Appendable writer, @Nonnull JsonObject data) {
        GsonProvider.getPrettyPrinting().toJson((JsonElement)data, writer);
    }

    public static void writeElement(@Nonnull Appendable writer, @Nonnull JsonElement element) {
        GsonProvider.get().toJson(element, writer);
    }

    public static void writeElementPretty(@Nonnull Appendable writer, @Nonnull JsonElement element) {
        GsonProvider.getPrettyPrinting().toJson(element, writer);
    }

    @Nonnull
    public static String toString(@Nonnull JsonElement element) {
        return (String)Preconditions.checkNotNull((Object)GsonProvider.get().toJson(element));
    }

    @Nonnull
    public static String toStringPretty(@Nonnull JsonElement element) {
        return (String)Preconditions.checkNotNull((Object)GsonProvider.getPrettyPrinting().toJson(element));
    }

    private GsonProvider() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

