/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.function;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public final class Predicates {
    public static <A, B> Predicate<A> compose(Function<A, ? extends B> function, Predicate<B> predicate) {
        Preconditions.checkNotNull(function, (Object)"function");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        return input -> predicate.test(function.apply(input));
    }

    public static <T> Predicate<T> alwaysTrue() {
        return ObjectPredicate.ALWAYS_TRUE.cast();
    }

    public static <T> Predicate<T> alwaysFalse() {
        return ObjectPredicate.ALWAYS_FALSE.cast();
    }

    public static <T> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.cast();
    }

    public static <A, B> Predicate<A> isNull(Function<A, ? extends B> composeFunction) {
        return Predicates.compose(composeFunction, Predicates.isNull());
    }

    public static <T> Predicate<T> notNull() {
        return ObjectPredicate.NOT_NULL.cast();
    }

    public static <A, B> Predicate<A> notNull(Function<A, ? extends B> composeFunction) {
        return Predicates.compose(composeFunction, Predicates.notNull());
    }

    public static <T> Predicate<T> equalTo(@Nullable Object target) {
        return target == null ? Objects::isNull : target::equals;
    }

    public static <A, B> Predicate<A> equalTo(Function<A, ? extends B> composeFunction, @Nullable Object target) {
        return Predicates.compose(composeFunction, Predicates.equalTo(target));
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return collection::contains;
    }

    public static <A, B> Predicate<A> in(Function<A, ? extends B> composeFunction, Collection<? extends B> collection) {
        return Predicates.compose(composeFunction, Predicates.in(collection));
    }

    @SafeVarargs
    public static <T> Predicate<T> in(T ... args) {
        return input -> {
            if (input == null) {
                for (Object t : args) {
                    if (t != null) continue;
                    return true;
                }
            } else {
                for (Object t : args) {
                    if (!input.equals(t)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    @SafeVarargs
    public static <A, B> Predicate<A> in(Function<A, ? extends B> composeFunction, B ... args) {
        return Predicates.compose(composeFunction, Predicates.in(args));
    }

    public static <T> Predicate<T> instanceOf(Class<?> clazz) {
        return clazz::isInstance;
    }

    public static <A, B> Predicate<A> instanceOf(Function<A, ? extends B> composeFunction, Class<?> clazz) {
        return Predicates.compose(composeFunction, Predicates.instanceOf(clazz));
    }

    private Predicates() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static enum ObjectPredicate implements Predicate<Object>
    {
        ALWAYS_TRUE{

            @Override
            public boolean test(Object o) {
                return true;
            }
        }
        ,
        ALWAYS_FALSE{

            @Override
            public boolean test(Object o) {
                return false;
            }
        }
        ,
        IS_NULL{

            @Override
            public boolean test(Object o) {
                return o == null;
            }
        }
        ,
        NOT_NULL{

            @Override
            public boolean test(Object o) {
                return o != null;
            }
        };


        <T> Predicate<T> cast() {
            return this;
        }
    }
}

