/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.event.functional.single;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.lucko.helper.event.SingleSubscription;
import me.lucko.helper.event.functional.ExpiryTestStage;
import me.lucko.helper.event.functional.SubscriptionBuilder;
import me.lucko.helper.event.functional.single.SingleBuilder;
import me.lucko.helper.event.functional.single.SingleHandlerList;
import me.lucko.helper.utils.Delegates;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

public interface SingleSubscriptionBuilder<T extends Event>
extends SubscriptionBuilder<T> {
    @Nonnull
    public static <T extends Event> SingleSubscriptionBuilder<T> newBuilder(@Nonnull Class<T> eventClass) {
        return SingleSubscriptionBuilder.newBuilder(eventClass, EventPriority.NORMAL);
    }

    @Nonnull
    public static <T extends Event> SingleSubscriptionBuilder<T> newBuilder(@Nonnull Class<T> eventClass, @Nonnull EventPriority priority) {
        Preconditions.checkNotNull(eventClass, (Object)"eventClass");
        Preconditions.checkNotNull((Object)priority, (Object)"priority");
        return new SingleBuilder<T>(eventClass, priority);
    }

    @Override
    @Nonnull
    default public SingleSubscriptionBuilder<T> expireIf(@Nonnull Predicate<T> predicate) {
        return this.expireIf(Delegates.predicateToBiPredicateSecond(predicate), ExpiryTestStage.PRE, ExpiryTestStage.POST_HANDLE);
    }

    @Override
    @Nonnull
    default public SingleSubscriptionBuilder<T> expireAfter(long duration, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        Preconditions.checkArgument((duration >= 1L ? 1 : 0) != 0, (Object)"duration < 1");
        long expiry = Math.addExact(System.currentTimeMillis(), unit.toMillis(duration));
        return this.expireIf((handler, event) -> System.currentTimeMillis() > expiry, ExpiryTestStage.PRE);
    }

    @Override
    @Nonnull
    default public SingleSubscriptionBuilder<T> expireAfter(long maxCalls) {
        Preconditions.checkArgument((maxCalls >= 1L ? 1 : 0) != 0, (Object)"maxCalls < 1");
        return this.expireIf((handler, event) -> handler.getCallCounter() >= maxCalls, ExpiryTestStage.PRE, ExpiryTestStage.POST_HANDLE);
    }

    @Override
    @Nonnull
    public SingleSubscriptionBuilder<T> filter(@Nonnull Predicate<T> var1);

    @Nonnull
    public SingleSubscriptionBuilder<T> expireIf(@Nonnull BiPredicate<SingleSubscription<T>, T> var1, ExpiryTestStage ... var2);

    @Nonnull
    public SingleSubscriptionBuilder<T> exceptionConsumer(@Nonnull BiConsumer<? super T, Throwable> var1);

    @Nonnull
    public SingleHandlerList<T> handlers();

    @Nonnull
    default public SingleSubscription<T> handler(@Nonnull Consumer<? super T> handler) {
        return (SingleSubscription)this.handlers().consumer((Consumer)handler).register();
    }

    @Nonnull
    default public SingleSubscription<T> biHandler(@Nonnull BiConsumer<SingleSubscription<T>, ? super T> handler) {
        return (SingleSubscription)this.handlers().biConsumer(handler).register();
    }
}

