/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.cooldown;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.lucko.helper.cooldown.Cooldown;
import me.lucko.helper.cooldown.CooldownMapImpl;

public interface CooldownMap<T> {
    @Nonnull
    public static <T> CooldownMap<T> create(@Nonnull Cooldown base) {
        Preconditions.checkNotNull((Object)base, (Object)"base");
        return new CooldownMapImpl(base);
    }

    @Nonnull
    public Cooldown getBase();

    @Nonnull
    public Cooldown get(@Nonnull T var1);

    public void put(@Nonnull T var1, @Nonnull Cooldown var2);

    @Nonnull
    public Map<T, Cooldown> getAll();

    public boolean test(@Nonnull T var1);

    public boolean testSilently(@Nonnull T var1);

    public long elapsed(@Nonnull T var1);

    public void reset(@Nonnull T var1);

    public long remainingMillis(@Nonnull T var1);

    public long remainingTime(@Nonnull T var1, @Nonnull TimeUnit var2);

    @Nonnull
    public OptionalLong getLastTested(@Nonnull T var1);
}

