/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.cooldown;

import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import me.lucko.helper.utils.TimeUtil;

public interface Cooldown {
    @Nonnull
    public static Cooldown ofTicks(long ticks) {
        return me.lucko.helper.utils.Cooldown.ofTicks(ticks);
    }

    @Nonnull
    public static Cooldown of(long amount, @Nonnull TimeUnit unit) {
        return me.lucko.helper.utils.Cooldown.of(amount, unit);
    }

    default public boolean test() {
        if (!this.testSilently()) {
            return false;
        }
        this.reset();
        return true;
    }

    default public boolean testSilently() {
        return this.elapsed() > this.getTimeout();
    }

    default public long elapsed() {
        return TimeUtil.now() - this.getLastTested().orElse(0L);
    }

    default public void reset() {
        this.setLastTested(TimeUtil.now());
    }

    default public long remainingMillis() {
        long diff = this.elapsed();
        return diff > this.getTimeout() ? 0L : this.getTimeout() - diff;
    }

    default public long remainingTime(TimeUnit unit) {
        return Math.max(0L, unit.convert(this.remainingMillis(), TimeUnit.MILLISECONDS));
    }

    public long getTimeout();

    @Nonnull
    public Cooldown copy();

    @Nonnull
    public OptionalLong getLastTested();

    public void setLastTested(long var1);
}

