/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.lucko.helper.Helper;
import me.lucko.helper.interfaces.Delegate;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.promise.ThreadContext;
import me.lucko.helper.scheduler.TaskBuilder;
import me.lucko.helper.terminable.Terminable;
import me.lucko.helper.timings.MCTiming;
import me.lucko.helper.timings.Timings;
import me.lucko.helper.utils.Delegates;
import me.lucko.helper.utils.Log;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;

@NonnullByDefault
public final class Scheduler {
    private static final Executor SYNC_EXECUTOR = new SyncExecutor();
    private static final Executor ASYNC_EXECUTOR_BUKKIT = new BukkitAsyncExecutor();
    private static final ExecutorService ASYNC_EXECUTOR_HELPER = new HelperAsyncExecutor();
    public static final Consumer<Throwable> EXCEPTION_CONSUMER = throwable -> {
        Log.severe("[SCHEDULER] Exception thrown whilst executing task");
        throwable.printStackTrace();
    };

    public static synchronized Executor sync() {
        return SYNC_EXECUTOR;
    }

    public static synchronized Executor async() {
        return ASYNC_EXECUTOR_HELPER;
    }

    public static synchronized Executor bukkitAsync() {
        return ASYNC_EXECUTOR_BUKKIT;
    }

    public static synchronized ExecutorService internalAsync() {
        return ASYNC_EXECUTOR_HELPER;
    }

    public static BukkitScheduler bukkit() {
        return Helper.bukkitScheduler();
    }

    public static TaskBuilder builder() {
        return TaskBuilder.newBuilder();
    }

    public static <T> Promise<T> supply(ThreadContext context, Supplier<T> supplier) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        return Promise.supplying(context, supplier);
    }

    public static <T> Promise<T> supplySync(Supplier<T> supplier) {
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        return Promise.supplyingSync(supplier);
    }

    public static <T> Promise<T> supplyAsync(Supplier<T> supplier) {
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        return Promise.supplyingAsync(supplier);
    }

    public static <T> Promise<T> call(ThreadContext context, Callable<T> callable) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        Preconditions.checkNotNull(callable, (Object)"callable");
        return Promise.supplying(context, Delegates.callableToSupplier(callable));
    }

    public static <T> Promise<T> callSync(Callable<T> callable) {
        Preconditions.checkNotNull(callable, (Object)"callable");
        return Promise.supplyingSync(Delegates.callableToSupplier(callable));
    }

    public static <T> Promise<T> callAsync(Callable<T> callable) {
        Preconditions.checkNotNull(callable, (Object)"callable");
        return Promise.supplyingAsync(Delegates.callableToSupplier(callable));
    }

    public static Promise<Void> run(ThreadContext context, Runnable runnable) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        return Promise.supplyingSync(Delegates.runnableToSupplier(runnable));
    }

    public static Promise<Void> runSync(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        return Promise.supplyingSync(Delegates.runnableToSupplier(runnable));
    }

    public static Promise<Void> runAsync(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        return Promise.supplyingAsync(Delegates.runnableToSupplier(runnable));
    }

    public static <T> Consumer<T> consuming(ThreadContext context, Consumer<? super T> action) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        switch (context) {
            case SYNC: {
                return Scheduler.consumingSync(action);
            }
            case ASYNC: {
                return Scheduler.consumingAsync(action);
            }
        }
        throw new AssertionError();
    }

    public static <T> Consumer<T> consumingSync(Consumer<? super T> action) {
        Promise promise = Promise.empty();
        promise.thenAcceptSync(action);
        return promise::supply;
    }

    public static <T> Consumer<T> consumingAsync(Consumer<? super T> action) {
        Promise promise = Promise.empty();
        promise.thenAcceptAsync(action);
        return promise::supply;
    }

    public static <T> Promise<T> supplyLater(ThreadContext context, Supplier<T> supplier, long delay) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        return Promise.supplyingDelayed(context, supplier, delay);
    }

    public static <T> Promise<T> supplyLaterSync(Supplier<T> supplier, long delay) {
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        return Promise.supplyingDelayedSync(supplier, delay);
    }

    public static <T> Promise<T> supplyLaterAsync(Supplier<T> supplier, long delay) {
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        return Promise.supplyingDelayedAsync(supplier, delay);
    }

    public static <T> Promise<T> callLater(ThreadContext context, Callable<T> callable, long delay) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        Preconditions.checkNotNull(callable, (Object)"callable");
        return Promise.supplyingDelayed(context, Delegates.callableToSupplier(callable), delay);
    }

    public static <T> Promise<T> callLaterSync(Callable<T> callable, long delay) {
        Preconditions.checkNotNull(callable, (Object)"callable");
        return Promise.supplyingDelayedSync(Delegates.callableToSupplier(callable), delay);
    }

    public static <T> Promise<T> callLaterAsync(Callable<T> callable, long delay) {
        Preconditions.checkNotNull(callable, (Object)"callable");
        return Promise.supplyingDelayedAsync(Delegates.callableToSupplier(callable), delay);
    }

    public static Promise<Void> runLater(ThreadContext context, Runnable runnable, long delay) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        return Promise.supplyingDelayed(context, Delegates.runnableToSupplier(runnable), delay);
    }

    public static Promise<Void> runLaterSync(Runnable runnable, long delay) {
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        return Promise.supplyingDelayedSync(Delegates.runnableToSupplier(runnable), delay);
    }

    public static Promise<Void> runLaterAsync(Runnable runnable, long delay) {
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        return Promise.supplyingDelayedAsync(Delegates.runnableToSupplier(runnable), delay);
    }

    public static Task runTaskRepeating(ThreadContext context, Consumer<Task> consumer, long delay, long interval) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        switch (context) {
            case SYNC: {
                return Scheduler.runTaskRepeatingSync(consumer, delay, interval);
            }
            case ASYNC: {
                return Scheduler.runTaskRepeatingAsync(consumer, delay, interval);
            }
        }
        throw new AssertionError();
    }

    public static Task runTaskRepeatingSync(Consumer<Task> consumer, long delay, long interval) {
        Preconditions.checkNotNull(consumer, (Object)"consumer");
        HelperTask task = new HelperTask(consumer);
        task.runTaskTimer((Plugin)LoaderUtils.getPlugin(), delay, interval);
        return task;
    }

    public static Task runTaskRepeatingAsync(Consumer<Task> consumer, long delay, long interval) {
        Preconditions.checkNotNull(consumer, (Object)"consumer");
        HelperTask task = new HelperTask(consumer);
        task.runTaskTimerAsynchronously((Plugin)LoaderUtils.getPlugin(), delay, interval);
        return task;
    }

    public static Task runTaskRepeating(ThreadContext context, Runnable runnable, long delay, long interval) {
        Preconditions.checkNotNull((Object)((Object)context), (Object)"context");
        switch (context) {
            case SYNC: {
                return Scheduler.runTaskRepeatingSync(runnable, delay, interval);
            }
            case ASYNC: {
                return Scheduler.runTaskRepeatingAsync(runnable, delay, interval);
            }
        }
        throw new AssertionError();
    }

    public static Task runTaskRepeatingSync(Runnable runnable, long delay, long interval) {
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        return Scheduler.runTaskRepeatingSync(Delegates.runnableToConsumer(runnable), delay, interval);
    }

    public static Task runTaskRepeatingAsync(Runnable runnable, long delay, long interval) {
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        return Scheduler.runTaskRepeatingAsync(Delegates.runnableToConsumer(runnable), delay, interval);
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        return new SchedulerWrappedRunnable(runnable);
    }

    private Scheduler() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static final class SchedulerWrappedRunnable
    implements Runnable,
    Delegate<Runnable> {
        private final Runnable delegate;

        private SchedulerWrappedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try (MCTiming t = Timings.ofStart("helper-scheduler: " + Delegate.resolve(this.delegate).getClass().getName());){
                this.delegate.run();
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
            }
        }

        @Override
        public Runnable getDelegate() {
            return this.delegate;
        }
    }

    private static class HelperTask
    extends BukkitRunnable
    implements Task {
        private final Consumer<Task> backingTask;
        private final MCTiming timing;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final AtomicBoolean shouldStop = new AtomicBoolean(false);

        private HelperTask(Consumer<Task> backingTask) {
            this.backingTask = backingTask;
            this.timing = Timings.of("helper-scheduler: " + Delegate.resolve(backingTask).getClass().getName());
        }

        public void run() {
            if (this.shouldStop.get()) {
                this.cancel();
                return;
            }
            try (MCTiming t = this.timing.startTiming();){
                this.backingTask.accept(this);
                this.counter.incrementAndGet();
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
            }
            if (this.shouldStop.get()) {
                this.cancel();
            }
        }

        @Override
        public int getTimesRan() {
            return this.counter.get();
        }

        @Override
        public boolean stop() {
            return !this.shouldStop.getAndSet(true);
        }

        @Override
        public int getBukkitId() {
            return this.getTaskId();
        }

        @Override
        public boolean terminate() {
            return this.stop();
        }

        @Override
        public boolean hasTerminated() {
            return this.shouldStop.get();
        }
    }

    private static final class HelperAsyncExecutor
    extends ThreadPoolExecutor {
        private HelperAsyncExecutor() {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("helper-scheduler-%d").build());
        }

        @Override
        public void execute(Runnable runnable) {
            super.execute(Scheduler.wrapRunnable(runnable));
        }
    }

    private static final class BukkitAsyncExecutor
    implements Executor {
        private BukkitAsyncExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            Scheduler.bukkit().runTaskAsynchronously((Plugin)LoaderUtils.getPlugin(), Scheduler.wrapRunnable(runnable));
        }
    }

    private static final class SyncExecutor
    implements Executor {
        private SyncExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            Scheduler.bukkit().scheduleSyncDelayedTask((Plugin)LoaderUtils.getPlugin(), Scheduler.wrapRunnable(runnable));
        }
    }

    @NonnullByDefault
    public static interface Task
    extends Terminable {
        public int getTimesRan();

        public boolean stop();

        public int getBukkitId();
    }
}

