/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper;

import com.google.common.reflect.TypeToken;
import javax.annotation.Nonnull;
import me.lucko.helper.Helper;
import me.lucko.helper.Scheduler;
import me.lucko.helper.event.functional.merged.MergedSubscriptionBuilder;
import me.lucko.helper.event.functional.single.SingleSubscriptionBuilder;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

public final class Events {
    @Nonnull
    public static <T extends Event> SingleSubscriptionBuilder<T> subscribe(@Nonnull Class<T> eventClass) {
        return SingleSubscriptionBuilder.newBuilder(eventClass);
    }

    @Nonnull
    public static <T extends Event> SingleSubscriptionBuilder<T> subscribe(@Nonnull Class<T> eventClass, @Nonnull EventPriority priority) {
        return SingleSubscriptionBuilder.newBuilder(eventClass, priority);
    }

    @Nonnull
    public static <T> MergedSubscriptionBuilder<T> merge(@Nonnull Class<T> handledClass) {
        return MergedSubscriptionBuilder.newBuilder(handledClass);
    }

    @Nonnull
    public static <T> MergedSubscriptionBuilder<T> merge(@Nonnull TypeToken<T> type) {
        return MergedSubscriptionBuilder.newBuilder(type);
    }

    @Nonnull
    @SafeVarargs
    public static <S extends Event> MergedSubscriptionBuilder<S> merge(@Nonnull Class<S> superClass, Class<? extends S> ... eventClasses) {
        return MergedSubscriptionBuilder.newBuilder(superClass, eventClasses);
    }

    @Nonnull
    @SafeVarargs
    public static <S extends Event> MergedSubscriptionBuilder<S> merge(@Nonnull Class<S> superClass, @Nonnull EventPriority priority, Class<? extends S> ... eventClasses) {
        return MergedSubscriptionBuilder.newBuilder(superClass, priority, eventClasses);
    }

    public static void call(@Nonnull Event event) {
        Helper.plugins().callEvent(event);
    }

    public static void callAsync(@Nonnull Event event) {
        Scheduler.runAsync(() -> Events.call(event));
    }

    public static void callSync(@Nonnull Event event) {
        Scheduler.runSync(() -> Events.call(event));
    }

    @Nonnull
    public static <T extends Event> T callAndReturn(@Nonnull T event) {
        Helper.plugins().callEvent(event);
        return event;
    }

    @Nonnull
    public static <T extends Event> T callAsyncAndJoin(@Nonnull T event) {
        return (T)Scheduler.supplyAsync(() -> Events.callAndReturn(event)).join();
    }

    @Nonnull
    public static <T extends Event> T callSyncAndJoin(@Nonnull T event) {
        return (T)Scheduler.supplySync(() -> Events.callAndReturn(event)).join();
    }

    private Events() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

