/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.streams.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import me.lucko.helper.sql.streams.UncheckedSqlException;
import me.lucko.helper.sql.streams.util.Closeable;
import me.lucko.helper.sql.streams.util.DummyDataSource;
import me.lucko.helper.sql.streams.util.Wrap;

public class SingleConnectionDataSource
extends DummyDataSource
implements Closeable {
    private final AtomicBoolean inUse = new AtomicBoolean(false);
    private final Connection connection;
    private final Connection proxy;

    public SingleConnectionDataSource(Connection connection) {
        this.connection = connection;
        this.proxy = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (proxy, method, args) -> {
            try {
                if (method.getName().equals("close") && method.getParameterCount() == 0) {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    this.releaseConnection();
                    return null;
                }
                if (method.getName().equals("isClosed") && method.getParameterCount() == 0) {
                    return !this.inUse.get();
                }
                return method.invoke((Object)connection, args);
            }
            catch (InvocationTargetException e) {
                RuntimeException exception;
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    exception = new UncheckedSqlException((SQLException)cause);
                } else {
                    if (cause instanceof RuntimeException) {
                        cause.addSuppressed(e);
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        cause.addSuppressed(e);
                        throw (Error)cause;
                    }
                    exception = new RuntimeException(cause);
                }
                exception.addSuppressed(e);
                throw exception;
            }
        });
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.inUse.getAndSet(true)) {
            throw new IllegalStateException("Connection already in use");
        }
        return this.proxy;
    }

    @Override
    public void close() {
        Wrap.execute(this.connection::close);
    }

    private void releaseConnection() {
        Wrap.execute(() -> this.connection.setAutoCommit(true));
        this.inUse.set(false);
    }
}

