/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.streams.impl;

import java.sql.Connection;
import me.lucko.helper.sql.streams.Transaction;
import me.lucko.helper.sql.streams.impl.SqlImpl;
import me.lucko.helper.sql.streams.util.Wrap;

class TransactionImpl
extends SqlImpl
implements Transaction {
    private final Connection connection;

    TransactionImpl(SqlImpl sql) {
        super(sql.bindings);
        this.connection = sql.getConnection();
        Wrap.execute(() -> this.connection.setAutoCommit(false));
    }

    TransactionImpl(SqlImpl sql, int isolationLevel) {
        super(sql.bindings);
        this.connection = sql.getConnection();
        Wrap.execute(() -> {
            this.connection.setAutoCommit(false);
            this.connection.setTransactionIsolation(isolationLevel);
        });
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    protected boolean closeConnectionAfterAction() {
        return false;
    }

    @Override
    public Transaction commit() {
        Wrap.execute(this.connection::commit);
        return this;
    }

    @Override
    public Transaction rollback() {
        Wrap.execute(this.connection::rollback);
        return this;
    }

    @Override
    public void close() {
        Wrap.execute(() -> {
            this.connection.rollback();
            this.connection.close();
        });
    }
}

