/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.streams.impl;

import java.net.URL;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import me.lucko.helper.sql.streams.PreparedStatementBinderByIndex;
import me.lucko.helper.sql.streams.ResultSetRetrieverByIndex;
import me.lucko.helper.sql.streams.ResultSetRetrieverByName;

public final class SqlBindings {
    private final Map<Class<?>, PreparedStatementBinderByIndex<?>> binders = new HashMap();
    private final Map<Class<?>, Bindings<?>> retrievers = new HashMap();

    SqlBindings() {
        this.addMapping(Date.class, ResultSet::getDate, ResultSet::getDate, PreparedStatement::setDate);
        this.addMapping(Time.class, ResultSet::getTime, ResultSet::getTime, PreparedStatement::setTime);
        this.addMapping(Timestamp.class, ResultSet::getTimestamp, ResultSet::getTimestamp, PreparedStatement::setTimestamp);
        this.addMapping(LocalDate.class, (rs, i) -> rs.getDate(i).toLocalDate(), (rs, name) -> rs.getDate(name).toLocalDate(), (statement, index, value) -> statement.setDate(index, Date.valueOf(value)));
        this.addMapping(LocalDateTime.class, (rs, i) -> rs.getTimestamp(i).toLocalDateTime(), (rs, name) -> rs.getTimestamp(name).toLocalDateTime(), (statement, index, value) -> statement.setTimestamp(index, Timestamp.valueOf(value)));
        this.addMapping(LocalTime.class, (rs, i) -> rs.getTime(i).toLocalTime(), (rs, name) -> rs.getTime(name).toLocalTime(), (statement, index, value) -> statement.setTime(index, Time.valueOf(value)));
        this.addMapping(String.class, ResultSet::getString, ResultSet::getString, PreparedStatement::setString);
        this.addMapping(Long.class, ResultSet::getLong, ResultSet::getLong, PreparedStatement::setLong);
        this.addMapping(Long.TYPE, ResultSet::getLong, ResultSet::getLong, PreparedStatement::setLong);
        this.addMapping(Integer.class, ResultSet::getInt, ResultSet::getInt, PreparedStatement::setInt);
        this.addMapping(Integer.TYPE, ResultSet::getInt, ResultSet::getInt, PreparedStatement::setInt);
        this.addMapping(Short.class, ResultSet::getShort, ResultSet::getShort, PreparedStatement::setShort);
        this.addMapping(Short.TYPE, ResultSet::getShort, ResultSet::getShort, PreparedStatement::setShort);
        this.addMapping(Byte.class, ResultSet::getByte, ResultSet::getByte, PreparedStatement::setByte);
        this.addMapping(Byte.TYPE, ResultSet::getByte, ResultSet::getByte, PreparedStatement::setByte);
        this.addMapping(Boolean.class, ResultSet::getBoolean, ResultSet::getBoolean, PreparedStatement::setBoolean);
        this.addMapping(Boolean.TYPE, ResultSet::getBoolean, ResultSet::getBoolean, PreparedStatement::setBoolean);
        this.addMapping(URL.class, ResultSet::getURL, ResultSet::getURL, PreparedStatement::setURL);
        this.addMapping(byte[].class, ResultSet::getBytes, ResultSet::getBytes, PreparedStatement::setBytes);
    }

    <T> void addMapping(Class<T> clazz, ResultSetRetrieverByIndex<T> fromBindingWithIndex, ResultSetRetrieverByName<T> fromBindingWithName, PreparedStatementBinderByIndex<T> preparedStatementBinderByIndex) {
        this.binders.put(clazz, preparedStatementBinderByIndex);
        this.retrievers.put(clazz, new Bindings<T>(fromBindingWithIndex, fromBindingWithName));
    }

    public <Statement extends PreparedStatement> Statement bind(Statement stmt, Object[] params, int offset) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            this.bind(stmt, i + offset + 1, params[i]);
        }
        return stmt;
    }

    public <T> void bind(PreparedStatement stmt, int index, T value) throws SQLException {
        PreparedStatementBinderByIndex<Object> toSqlBinding;
        if (value.getClass().isEnum()) {
            toSqlBinding = (s, i, v) -> s.setInt(i, ((Enum)v).ordinal());
        } else {
            toSqlBinding = this.binders.get(value.getClass());
            if (toSqlBinding == null) {
                throw new IllegalArgumentException("No binding for " + value.getClass());
            }
        }
        toSqlBinding.bind(stmt, index, value);
    }

    public <T> T retrieve(ResultSet resultSet, int index, Class<T> clazz) throws SQLException {
        ResultSetRetrieverByIndex fromSqlBinding;
        if (clazz.isEnum()) {
            fromSqlBinding = (rs, i) -> clazz.getEnumConstants()[rs.getInt(i)];
        } else {
            Bindings<?> bindings = this.retrievers.get(clazz);
            if (bindings == null) {
                throw new IllegalArgumentException("No binding for " + clazz);
            }
            fromSqlBinding = ((Bindings)bindings).retrieverByIndex;
        }
        Object retrieved = fromSqlBinding.retrieve(resultSet, index);
        return (T)(resultSet.wasNull() ? null : retrieved);
    }

    public <T> T retrieve(ResultSet resultSet, String name, Class<T> clazz) throws SQLException {
        ResultSetRetrieverByName fromSqlBinding;
        if (clazz.isEnum()) {
            fromSqlBinding = (rs, i) -> clazz.getEnumConstants()[rs.getInt(i)];
        } else {
            Bindings<?> bindings = this.retrievers.get(clazz);
            if (bindings == null) {
                throw new IllegalArgumentException("No binding for " + clazz);
            }
            fromSqlBinding = ((Bindings)bindings).retrieverByName;
        }
        Object retrieved = fromSqlBinding.retrieve(resultSet, name);
        return (T)(resultSet.wasNull() ? null : retrieved);
    }

    public <T> boolean hasBinder(Class<T> clazz) {
        return this.binders.containsKey(clazz);
    }

    public class Bindings<T> {
        private final ResultSetRetrieverByIndex<T> retrieverByIndex;
        private final ResultSetRetrieverByName<T> retrieverByName;

        public Bindings(ResultSetRetrieverByIndex<T> retrieverByIndex, ResultSetRetrieverByName<T> retrieverByName) {
            this.retrieverByIndex = retrieverByIndex;
            this.retrieverByName = retrieverByName;
        }
    }
}

