/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.streams.impl;

import java.sql.ResultSet;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.lucko.helper.sql.streams.util.SqlFunction;
import me.lucko.helper.sql.streams.util.Wrap;

public class ResultSetSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    private final SqlFunction<ResultSet, T> mapping;
    private final ResultSet resultSet;

    static <T> Stream<T> stream(SqlFunction<ResultSet, T> mapping, ResultSet resultSet) {
        return (Stream)StreamSupport.stream(new ResultSetSpliterator<T>(mapping, resultSet), false).onClose(() -> Wrap.execute(resultSet::close));
    }

    private ResultSetSpliterator(SqlFunction<ResultSet, T> mapping, ResultSet resultSet) {
        super(Long.MAX_VALUE, 16);
        this.resultSet = resultSet;
        this.mapping = mapping;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> consumer) {
        return Wrap.get(() -> {
            boolean hasNext = this.resultSet.next();
            if (hasNext) {
                consumer.accept((T)this.mapping.apply(this.resultSet));
            }
            return hasNext;
        });
    }
}

