/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.streams.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.stream.Stream;
import me.lucko.helper.sql.streams.Query;
import me.lucko.helper.sql.streams.impl.ParameterProviderImpl;
import me.lucko.helper.sql.streams.impl.ResultSetSpliterator;
import me.lucko.helper.sql.streams.impl.SqlImpl;
import me.lucko.helper.sql.streams.util.SqlFunction;
import me.lucko.helper.sql.streams.util.Wrap;

class QueryImpl
extends ParameterProviderImpl<Query, PreparedStatement>
implements Query {
    private final Connection connection;
    private final boolean closeConnection;

    QueryImpl(SqlImpl sql, Connection connection, PreparedStatement statement, boolean closeConnection) {
        super(statement, sql.bindings);
        this.connection = connection;
        this.closeConnection = closeConnection;
    }

    @Override
    public <R> Stream<R> map(SqlFunction<ResultSet, R> mapping) {
        return (Stream)ResultSetSpliterator.stream(mapping, Wrap.get(this.statement::executeQuery)).onClose(this::close);
    }

    @Override
    public void close() {
        super.close();
        if (this.closeConnection) {
            Wrap.execute(this.connection::close);
        }
    }
}

