/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.streams;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Optional;
import javax.sql.DataSource;
import me.lucko.helper.sql.streams.BatchUpdate;
import me.lucko.helper.sql.streams.Execute;
import me.lucko.helper.sql.streams.PreparedStatementBinderByIndex;
import me.lucko.helper.sql.streams.Query;
import me.lucko.helper.sql.streams.Transaction;
import me.lucko.helper.sql.streams.Update;
import me.lucko.helper.sql.streams.impl.SqlImpl;
import me.lucko.helper.sql.streams.util.Closeable;
import me.lucko.helper.sql.streams.util.SingleConnectionDataSource;
import me.lucko.helper.sql.streams.util.SqlFunction;

public interface SqlStream
extends Closeable {
    public static SqlStream connect(Connection connection) {
        return SqlStream.connect(new SingleConnectionDataSource(connection));
    }

    public static SqlStream connect(DataSource dataSource) {
        return new SqlImpl(dataSource);
    }

    public <T> SqlStream registerCustomBinding(Class<T> var1, PreparedStatementBinderByIndex<T> var2);

    public Transaction transaction();

    public Transaction transaction(Transaction.IsolationLevel var1);

    public Query query(SqlFunction<Connection, PreparedStatement> var1);

    default public Query query(String sql) {
        return this.query((Connection conn) -> conn.prepareStatement(sql));
    }

    public Update update(SqlFunction<Connection, PreparedStatement> var1);

    default public Update update(String sql) {
        return this.update((Connection conn) -> conn.prepareStatement(sql));
    }

    public BatchUpdate batchUpdate(String var1);

    public Execute<PreparedStatement> execute(String var1);

    public Execute<CallableStatement> call(String var1);

    default public <R> Optional<R> first(String sql, SqlFunction<ResultSet, R> mapping, Object ... parameters) {
        try (Query query = (Query)this.query(sql).with(parameters);){
            Optional<R> optional = query.first(mapping);
            return optional;
        }
    }

    default public void exec(String sql, Object ... parameters) {
        try (Execute execute = (Execute)this.execute(sql).with(parameters);){
            execute.execute();
        }
    }

    @Override
    public void close();
}

