/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.plugin;

import java.sql.PreparedStatement;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.sql.Sql;
import me.lucko.helper.sql.batch.BatchBuilder;
import me.lucko.helper.sql.streams.util.SqlConsumer;

public class HelperSqlBatchBuilder
implements BatchBuilder {
    @Nonnull
    private final Sql owner;
    @Nonnull
    private final String statement;
    @Nonnull
    private final LinkedList<SqlConsumer<PreparedStatement>> handlers;

    public HelperSqlBatchBuilder(@Nonnull Sql owner, @Nonnull String statement) {
        this.owner = owner;
        this.statement = statement;
        this.handlers = new LinkedList();
    }

    @Override
    @Nonnull
    public String getStatement() {
        return this.statement;
    }

    @Nonnull
    public LinkedList<SqlConsumer<PreparedStatement>> getHandlers() {
        return this.handlers;
    }

    @Override
    public BatchBuilder reset() {
        this.handlers.clear();
        return this;
    }

    @Override
    public BatchBuilder batch(@Nonnull SqlConsumer<PreparedStatement> handler) {
        this.handlers.add(handler);
        return this;
    }

    @Override
    public void execute() {
        this.owner.executeBatch(this);
    }

    @Override
    @Nonnull
    public Promise<Void> executeAsync() {
        return this.owner.executeBatchAsync(this);
    }
}

