/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.plugin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import me.lucko.helper.sql.DatabaseCredentials;
import me.lucko.helper.sql.Sql;
import me.lucko.helper.sql.batch.BatchBuilder;
import me.lucko.helper.sql.external.hikari.HikariConfig;
import me.lucko.helper.sql.external.hikari.HikariDataSource;
import me.lucko.helper.sql.plugin.HelperSqlBatchBuilder;
import me.lucko.helper.sql.streams.SqlStream;
import me.lucko.helper.sql.streams.util.SqlConsumer;
import me.lucko.helper.sql.streams.util.SqlFunction;
import org.intellij.lang.annotations.Language;

public class HelperSql
implements Sql {
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger(0);
    private static final Properties PROPERTIES;
    private static final String DATA_SOURCE_CLASS = "me.lucko.helper.sql.external.mariadb.jdbc.MySQLDataSource";
    private static final int MAXIMUM_POOL_SIZE;
    private static final int MINIMUM_IDLE = 10;
    private static final long MAX_LIFETIME;
    private static final long CONNECTION_TIMEOUT;
    private static final long LEAK_DETECTION_THRESHOLD;
    private final HikariDataSource source;
    private final SqlStream stream;

    public HelperSql(@Nonnull DatabaseCredentials credentials) {
        HikariConfig hikari = new HikariConfig();
        hikari.setPoolName("helper-sql-" + POOL_COUNTER.getAndIncrement());
        hikari.setDataSourceClassName(DATA_SOURCE_CLASS);
        hikari.addDataSourceProperty("serverName", credentials.getAddress());
        hikari.addDataSourceProperty("port", credentials.getPort());
        hikari.addDataSourceProperty("databaseName", credentials.getDatabase());
        hikari.setUsername(credentials.getUsername());
        hikari.setPassword(credentials.getPassword());
        hikari.setDataSourceProperties(PROPERTIES);
        hikari.setMaximumPoolSize(MAXIMUM_POOL_SIZE);
        hikari.setMinimumIdle(10);
        hikari.setMaxLifetime(MAX_LIFETIME);
        hikari.setConnectionTimeout(CONNECTION_TIMEOUT);
        hikari.setLeakDetectionThreshold(LEAK_DETECTION_THRESHOLD);
        hikari.addDataSourceProperty("properties", "useUnicode=true;characterEncoding=utf8");
        this.source = new HikariDataSource(hikari);
        this.stream = SqlStream.connect(this.source);
    }

    @Override
    @Nonnull
    public HikariDataSource getHikari() {
        return this.source;
    }

    @Override
    @Nonnull
    public Connection getConnection() throws SQLException {
        return Objects.requireNonNull(this.source.getConnection(), "connection is null");
    }

    @Override
    @Nonnull
    public SqlStream stream() {
        return this.stream;
    }

    @Override
    public void execute(@Nonnull @Language(value="MySQL") String statement, @Nonnull SqlConsumer<PreparedStatement> preparer) {
        try (Connection c = this.getConnection();
             PreparedStatement s = c.prepareStatement(statement);){
            preparer.accept(s);
            s.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public <R> Optional<R> query(@Nonnull @Language(value="MySQL") String query, @Nonnull SqlConsumer<PreparedStatement> preparer, @Nonnull SqlFunction<ResultSet, R> handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void executeBatch(@Nonnull BatchBuilder builder) {
        if (builder.getHandlers().isEmpty()) {
            return;
        }
        if (builder.getHandlers().size() == 1) {
            this.execute(builder.getStatement(), builder.getHandlers().iterator().next());
            return;
        }
        try (Connection c = this.getConnection();
             PreparedStatement s = c.prepareStatement(builder.getStatement());){
            for (SqlConsumer<PreparedStatement> handlers : builder.getHandlers()) {
                handlers.accept(s);
                s.addBatch();
            }
            s.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public BatchBuilder batch(@Nonnull @Language(value="MySQL") String statement) {
        return new HelperSqlBatchBuilder(this, statement);
    }

    public void close() {
        this.source.close();
    }

    static {
        MAXIMUM_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;
        MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
        CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
        LEAK_DETECTION_THRESHOLD = TimeUnit.SECONDS.toMillis(10L);
        PROPERTIES = new Properties();
        PROPERTIES.setProperty("useConfigs", "maxPerformance");
    }
}

