/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import me.lucko.helper.sql.external.mariadb.jdbc.UrlParser;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.FailoverProxy;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.impl.AuroraListener;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.impl.MastersFailoverListener;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.failover.impl.MastersSlavesListener;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.socket.SocketHandlerFunction;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.socket.SocketUtility;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.ProtocolLoggingProxy;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.AuroraProtocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.MasterProtocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.MastersSlavesProtocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.Protocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.pool.GlobalStateInfo;

public class Utils {
    private static final char[] hexArray;
    private static final Pattern IP_V4;
    private static final Pattern IP_V6;
    private static final Pattern IP_V6_COMPRESSED;
    private static final SocketHandlerFunction socketHandler;

    public static Socket standardSocket(UrlParser urlParser, String host) throws IOException {
        String socketFactoryName = urlParser.getOptions().socketFactory;
        if (socketFactoryName != null) {
            try {
                Class<?> socketFactoryClass = Class.forName(socketFactoryName);
                if (socketFactoryClass != null) {
                    Constructor<?> constructor = socketFactoryClass.getConstructor(new Class[0]);
                    SocketFactory socketFactory = (SocketFactory)constructor.newInstance(new Object[0]);
                    return socketFactory.createSocket();
                }
            }
            catch (Exception exp) {
                throw new IOException("Socket factory failed to initialized with option \"socketFactory\" set to \"" + urlParser.getOptions().socketFactory + "\"", exp);
            }
        }
        SocketFactory socketFactory = SocketFactory.getDefault();
        return socketFactory.createSocket();
    }

    public static String escapeString(String value, boolean noBackslashEscapes) {
        if (!value.contains("'")) {
            if (noBackslashEscapes) {
                return value;
            }
            if (!value.contains("\\")) {
                return value;
            }
        }
        String escaped = value.replace("'", "''");
        if (noBackslashEscapes) {
            return escaped;
        }
        return escaped.replace("\\", "\\\\");
    }

    public static byte[] encryptPassword(String password, byte[] seed, String passwordCharacterEncoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (password == null || password.isEmpty()) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] bytePwd = passwordCharacterEncoding != null && !passwordCharacterEncoding.isEmpty() ? password.getBytes(passwordCharacterEncoding) : password.getBytes();
        byte[] stage1 = messageDigest.digest(bytePwd);
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(stage2);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    public static byte[] copyWithLength(byte[] orig, int length) {
        byte[] result = new byte[length];
        int howMuchToCopy = length < orig.length ? length : orig.length;
        System.arraycopy(orig, 0, result, 0, howMuchToCopy);
        return result;
    }

    public static byte[] copyRange(byte[] orig, int from, int to) {
        int length = to - from;
        byte[] result = new byte[length];
        int howMuchToCopy = orig.length - from < length ? orig.length - from : length;
        System.arraycopy(orig, from, result, 0, howMuchToCopy);
        return result;
    }

    private static String replaceFunctionParameter(String functionString) {
        int index;
        if (!functionString.contains("SQL_")) {
            return functionString;
        }
        char[] input = functionString.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (index = 0; index < input.length && input[index] == ' '; ++index) {
        }
        while ((input[index] >= 'a' && index <= 122 || input[index] >= 'A' && input[index] <= 'Z') && index < input.length) {
            sb.append(input[index]);
            ++index;
        }
        String func = sb.toString().toLowerCase(Locale.ROOT);
        if ("convert".equals(func) || "timestampdiff".equals(func) || "timestampadd".equals(func)) {
            if ("timestampdiff".equals(func) || "timestampadd".equals(func)) {
                while (index < input.length && (Character.isWhitespace(input[index]) || input[index] == '(')) {
                    ++index;
                }
                if (index == input.length) {
                    return new String(input);
                }
                if (index >= input.length - 8) {
                    return new String(input);
                }
                String paramPrefix = new String(input, index, 8);
                if ("SQL_TSI_".equals(paramPrefix)) {
                    return new String(input, 0, index) + new String(input, index + 8, input.length - (index + 8));
                }
                return new String(input);
            }
            int lastCommaIndex = functionString.lastIndexOf(44);
            for (index = lastCommaIndex + 1; index < input.length && Character.isWhitespace(input[index]); ++index) {
            }
            if (index >= input.length - 4) {
                return new String(input);
            }
            String paramPrefix = new String(input, index, 4);
            if ("SQL_".equals(paramPrefix)) {
                return new String(input, 0, index) + new String(input, index + 4, input.length - (index + 4));
            }
        }
        return new String(input);
    }

    private static String resolveEscapes(String escaped, boolean noBackslashEscapes) throws SQLException {
        block15: {
            block14: {
                if (escaped.charAt(0) != '{' || escaped.charAt(escaped.length() - 1) != '}') {
                    throw new SQLException("unexpected escaped string");
                }
                int endIndex = escaped.length() - 1;
                String escapedLower = escaped.toLowerCase(Locale.ROOT);
                if (escaped.startsWith("{fn ")) {
                    String resolvedParams = Utils.replaceFunctionParameter(escaped.substring(4, endIndex));
                    return Utils.nativeSql(resolvedParams, noBackslashEscapes);
                }
                if (escapedLower.startsWith("{oj ")) {
                    return Utils.nativeSql(escaped.substring(4, endIndex), noBackslashEscapes);
                }
                if (escaped.startsWith("{d ")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{t ")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{ts ")) {
                    return escaped.substring(4, endIndex);
                }
                if (escaped.startsWith("{d'")) {
                    return escaped.substring(2, endIndex);
                }
                if (escaped.startsWith("{t'")) {
                    return escaped.substring(2, endIndex);
                }
                if (escaped.startsWith("{ts'")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{call ") || escaped.startsWith("{CALL ")) {
                    return Utils.nativeSql(escaped.substring(1, endIndex), noBackslashEscapes);
                }
                if (escaped.startsWith("{escape ")) {
                    return escaped.substring(1, endIndex);
                }
                if (escaped.startsWith("{?")) {
                    return Utils.nativeSql(escaped.substring(1, endIndex), noBackslashEscapes);
                }
                if (!escaped.startsWith("{ ") && !escaped.startsWith("{\n")) break block14;
                for (int i = 2; i < escaped.length(); ++i) {
                    if (Character.isWhitespace(escaped.charAt(i))) continue;
                    return Utils.resolveEscapes("{" + escaped.substring(i), noBackslashEscapes);
                }
                break block15;
            }
            if (!escaped.startsWith("{\r\n")) break block15;
            for (int i = 3; i < escaped.length(); ++i) {
                if (Character.isWhitespace(escaped.charAt(i))) continue;
                return Utils.resolveEscapes("{" + escaped.substring(i), noBackslashEscapes);
            }
        }
        throw new SQLException("unknown escape sequence " + escaped);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String nativeSql(String sql, boolean noBackslashEscapes) throws SQLException {
        if (!sql.contains("{")) {
            return sql;
        }
        StringBuilder escapeSequenceBuf = new StringBuilder();
        StringBuilder sqlBuffer = new StringBuilder();
        char[] charArray = sql.toCharArray();
        char lastChar = '\u0000';
        boolean inQuote = false;
        char quoteChar = '\u0000';
        boolean inComment = false;
        boolean isSlashSlashComment = false;
        int inEscapeSeq = 0;
        block9: for (int i = 0; i < charArray.length; ++i) {
            char car = charArray[i];
            if (lastChar == '\\' && !noBackslashEscapes) {
                sqlBuffer.append(car);
                continue;
            }
            switch (car) {
                case '\"': 
                case '\'': 
                case '`': {
                    if (inComment) break;
                    if (inQuote) {
                        if (quoteChar != car) break;
                        inQuote = false;
                        break;
                    }
                    inQuote = true;
                    quoteChar = car;
                    break;
                }
                case '*': {
                    if (inQuote || inComment || lastChar != 47) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case '-': 
                case '/': {
                    if (inQuote) break;
                    if (inComment) {
                        if (lastChar == '*' && !isSlashSlashComment) {
                            inComment = false;
                            break;
                        }
                        if (lastChar != car || !isSlashSlashComment) break;
                        inComment = false;
                        break;
                    }
                    if (lastChar == car) {
                        inComment = true;
                        isSlashSlashComment = true;
                        break;
                    }
                    if (lastChar != 42) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case 'S': {
                    if (inQuote || inComment || inEscapeSeq <= 0 || i + 4 >= charArray.length || charArray[i + 1] != 'Q' || charArray[i + 2] != 'L' || charArray[i + 3] != 'L' || charArray[i + 4] != '_') break;
                    if (i + 8 < charArray.length && charArray[i + 5] == 'T' && charArray[i + 6] == 'S' && charArray[i + 7] == 'I' && charArray[i + 8] == '_') {
                        i += 8;
                        continue block9;
                    }
                    i += 4;
                    continue block9;
                }
                case '\n': {
                    if (!inComment || !isSlashSlashComment) break;
                    inComment = false;
                    break;
                }
                case '{': {
                    if (inQuote || inComment) break;
                    ++inEscapeSeq;
                    break;
                }
                case '}': {
                    if (inQuote || inComment || --inEscapeSeq != 0) break;
                    escapeSequenceBuf.append(car);
                    sqlBuffer.append(Utils.resolveEscapes(escapeSequenceBuf.toString(), noBackslashEscapes));
                    escapeSequenceBuf.setLength(0);
                    continue block9;
                }
            }
            lastChar = car;
            if (inEscapeSeq > 0) {
                escapeSequenceBuf.append(car);
                continue;
            }
            sqlBuffer.append(car);
        }
        if (inEscapeSeq > 0) {
            throw new SQLException("Invalid escape sequence , missing closing '}' character in '" + sqlBuffer);
        }
        return sqlBuffer.toString();
    }

    public static Protocol retrieveProxy(UrlParser urlParser, GlobalStateInfo globalInfo) throws SQLException {
        ReentrantLock lock = new ReentrantLock();
        switch (urlParser.getHaMode()) {
            case AURORA: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(AuroraProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new AuroraListener(urlParser, globalInfo), lock)));
            }
            case REPLICATION: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(MastersSlavesProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersSlavesListener(urlParser, globalInfo), lock)));
            }
            case FAILOVER: 
            case SEQUENTIAL: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersFailoverListener(urlParser, globalInfo), lock)));
            }
        }
        Protocol protocol = Utils.getProxyLoggingIfNeeded(urlParser, new MasterProtocol(urlParser, globalInfo, lock));
        protocol.connectWithoutProxy();
        return protocol;
    }

    private static Protocol getProxyLoggingIfNeeded(UrlParser urlParser, Protocol protocol) {
        if (urlParser.getOptions().profileSql || urlParser.getOptions().slowQueryThresholdNanos != null) {
            return (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new ProtocolLoggingProxy(protocol, urlParser.getOptions()));
        }
        return protocol;
    }

    public static TimeZone getTimeZone(String id) throws SQLException {
        TimeZone tz = TimeZone.getTimeZone(id);
        if ("GMT".equals(tz.getID()) && !"GMT".equals(id)) {
            throw new SQLException("invalid timezone id '" + id + "'");
        }
        return tz;
    }

    public static Socket createSocket(UrlParser urlParser, String host) throws IOException {
        return socketHandler.apply(urlParser, host);
    }

    public static String hexdump(byte[] ... bytes) {
        return Utils.hexdump(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, bytes);
    }

    public static String hexdump(int maxQuerySizeToLog, int offset, int length, byte[] ... byteArr) {
        byte[] arr;
        switch (byteArr.length) {
            case 0: {
                return "";
            }
            case 1: {
                byte[] bytes = byteArr[0];
                if (bytes.length <= offset) {
                    return "";
                }
                int dataLength = Math.min(maxQuerySizeToLog, Math.min(bytes.length - offset, length));
                StringBuilder outputBuilder = new StringBuilder(dataLength * 5);
                outputBuilder.append("\n");
                Utils.writeHex(bytes, offset, dataLength, outputBuilder);
                return outputBuilder.toString();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (int i = 0; i < byteArr.length - 1; ++i) {
            arr = byteArr[i];
            Utils.writeHex(arr, 0, arr.length, sb);
        }
        arr = byteArr[byteArr.length - 1];
        int dataLength2 = Math.min(maxQuerySizeToLog, Math.min(arr.length - offset, length));
        Utils.writeHex(arr, offset, dataLength2, sb);
        return sb.toString();
    }

    private static void writeHex(byte[] bytes, int offset, int dataLength, StringBuilder outputBuilder) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        char[] hexaValue = new char[16];
        hexaValue[8] = 32;
        int posHexa = 0;
        for (int pos = offset; pos < dataLength + offset; ++pos) {
            int byteValue = bytes[pos] & 0xFF;
            outputBuilder.append(hexArray[byteValue >>> 4]).append(hexArray[byteValue & 0xF]).append(" ");
            int n = hexaValue[posHexa++] = byteValue > 31 && byteValue < 127 ? (int)byteValue : 46;
            if (posHexa == 8) {
                outputBuilder.append(" ");
            }
            if (posHexa != 16) continue;
            outputBuilder.append("    ").append(hexaValue).append("\n");
            posHexa = 0;
        }
        int remaining = posHexa;
        if (remaining > 0) {
            if (remaining < 8) {
                while (remaining < 8) {
                    outputBuilder.append("   ");
                    ++remaining;
                }
                outputBuilder.append(" ");
            }
            while (remaining < 16) {
                outputBuilder.append("   ");
                ++remaining;
            }
            outputBuilder.append("    ").append(hexaValue, 0, posHexa).append("\n");
        }
    }

    private static String getHex(byte[] raw) {
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(hexArray[(b & 0xF0) >> 4]).append(hexArray[b & 0xF]);
        }
        return hex.toString();
    }

    public static String byteArrayToHexString(byte[] bytes) {
        return bytes != null ? Utils.getHex(bytes) : "";
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String parseSessionVariables(String sessionVariable) {
        char[] chars;
        StringBuilder out = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        Parse state = Parse.Normal;
        boolean iskey = true;
        boolean singleQuotes = true;
        boolean first = true;
        String key = null;
        block7: for (char car : chars = sessionVariable.toCharArray()) {
            if (state == Parse.Escape) {
                sb.append(car);
                state = singleQuotes ? Parse.Quote : Parse.String;
                continue;
            }
            switch (car) {
                case '\"': {
                    if (state == Parse.Normal) {
                        state = Parse.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != Parse.String || singleQuotes) break;
                    state = Parse.Normal;
                    break;
                }
                case '\'': {
                    if (state == Parse.Normal) {
                        state = Parse.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != Parse.String || !singleQuotes) break;
                    state = Parse.Normal;
                    break;
                }
                case '\\': {
                    if (state != Parse.String) break;
                    state = Parse.Escape;
                    break;
                }
                case ',': 
                case ';': {
                    if (state != Parse.Normal) break;
                    if (!iskey) {
                        if (!first) {
                            out.append(",");
                        }
                        out.append(key);
                        out.append(sb.toString());
                        first = false;
                    } else {
                        key = sb.toString().trim();
                        if (!key.isEmpty()) {
                            if (!first) {
                                out.append(",");
                            }
                            out.append(key);
                            first = false;
                        }
                    }
                    iskey = true;
                    key = null;
                    sb = new StringBuilder();
                    continue block7;
                }
                case '=': {
                    if (state != Parse.Normal || !iskey) break;
                    key = sb.toString().trim();
                    iskey = false;
                    sb = new StringBuilder();
                }
            }
            sb.append(car);
        }
        if (!iskey) {
            if (!first) {
                out.append(",");
            }
            out.append(key);
            out.append(sb.toString());
            return out.toString();
        }
        String tmpkey = sb.toString().trim();
        if (!tmpkey.isEmpty() && !first) {
            out.append(",");
        }
        out.append(tmpkey);
        return out.toString();
    }

    public static boolean isIPv4(String ip) {
        return IP_V4.matcher(ip).matches();
    }

    public static boolean isIPv6(String ip) {
        return IP_V6.matcher(ip).matches() || IP_V6_COMPRESSED.matcher(ip).matches();
    }

    public static int transactionFromString(String txIsolation) throws SQLException {
        switch (txIsolation) {
            case "READ-UNCOMMITTED": {
                return 1;
            }
            case "READ-COMMITTED": {
                return 2;
            }
            case "REPEATABLE-READ": {
                return 4;
            }
            case "SERIALIZABLE": {
                return 8;
            }
        }
        throw new SQLException("unknown transaction isolation level");
    }

    static {
        SocketHandlerFunction init;
        hexArray = "0123456789ABCDEF".toCharArray();
        IP_V4 = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        IP_V6 = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
        IP_V6_COMPRESSED = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
        try {
            init = SocketUtility.getSocketHandler();
        }
        catch (Throwable t) {
            SocketHandlerFunction defaultSocketHandler;
            init = defaultSocketHandler = (urlParser, host) -> Utils.standardSocket(urlParser, host);
        }
        socketHandler = init;
    }

    private static enum Parse {
        Normal,
        String,
        Quote,
        Escape;

    }
}

