/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.protocol.authentication;

import java.sql.SQLException;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.AuthenticationPlugin;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.ClearPasswordPlugin;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.Ed25519PasswordPlugin;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.NativePasswordPlugin;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.OldPasswordPlugin;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.SendGssApiAuthPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.SendPamAuthPacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Options;

public class DefaultAuthenticationProvider {
    public static final String MYSQL_NATIVE_PASSWORD = "mysql_native_password";
    public static final String MYSQL_OLD_PASSWORD = "mysql_old_password";
    public static final String MYSQL_CLEAR_PASSWORD = "mysql_clear_password";
    public static final String MYSQL_ED25519_PASSWORD = "client_ed25519";
    private static final String GSSAPI_CLIENT = "auth_gssapi_client";
    private static final String DIALOG = "dialog";

    public static AuthenticationPlugin processAuthPlugin(String plugin, String password, byte[] authData, Options options) throws SQLException {
        switch (plugin) {
            case "mysql_native_password": {
                return new NativePasswordPlugin(password, authData, options.passwordCharacterEncoding);
            }
            case "mysql_old_password": {
                return new OldPasswordPlugin(password, authData);
            }
            case "mysql_clear_password": {
                return new ClearPasswordPlugin(password, options.passwordCharacterEncoding);
            }
            case "dialog": {
                return new SendPamAuthPacket(password, authData, options.passwordCharacterEncoding);
            }
            case "auth_gssapi_client": {
                return new SendGssApiAuthPacket(authData, options.servicePrincipalName);
            }
            case "client_ed25519": {
                return new Ed25519PasswordPlugin(password, authData, options.passwordCharacterEncoding);
            }
        }
        throw new SQLException("Client does not support authentication protocol requested by server. Consider upgrading MariaDB client. plugin was = " + plugin, "08004", 1251);
    }
}

