/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.io.socket;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharedMemorySocket
extends Socket {
    private static final String EVERYONE_SYNCHRONIZE_SDDL = "D:(A;;0x100000;;;WD)";
    private static final Map<String, Object> WIN32API_OPTIONS = new HashMap<String, Object>();
    private static final int BUFFERLEN = 16004;
    private InputStream is;
    private OutputStream os;
    private String memoryName;
    private WinNT.HANDLE serverRead;
    private WinNT.HANDLE serverWrote;
    private WinNT.HANDLE clientRead;
    private WinNT.HANDLE clientWrote;
    private WinNT.HANDLE connectionClosed;
    private Pointer view;
    private int bytesLeft;
    private int position;
    private int timeout = -1;

    public SharedMemorySocket(String name) throws IOException {
        if (!Platform.isWindows()) {
            throw new IOException("shared memory connections are only supported on Windows");
        }
        this.memoryName = name;
    }

    private static WinNT.HANDLE openEvent(String name) {
        return Kernel32.INSTANCE.OpenEvent(0x100002, false, name);
    }

    private static Pointer mapMemory(String mapName, int mode, int size) {
        WinNT.HANDLE mapping = Kernel32.INSTANCE.OpenFileMapping(mode, false, mapName);
        Pointer v = Kernel32.INSTANCE.MapViewOfFile(mapping, mode, 0, 0, new BaseTSD.SIZE_T((long)size));
        Kernel32.INSTANCE.CloseHandle(mapping);
        return v;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    private WinNT.HANDLE lockMutex() throws IOException {
        PointerByReference securityDescriptor = new PointerByReference();
        Advapi32.INSTANCE.ConvertStringSecurityDescriptorToSecurityDescriptor(EVERYONE_SYNCHRONIZE_SDDL, 1, securityDescriptor, null);
        Advapi32.SECURITY_ATTRIBUTES sa = new Advapi32.SECURITY_ATTRIBUTES();
        sa.nLength = sa.size();
        sa.lpSecurityDescriptor = securityDescriptor.getValue();
        sa.bInheritHandle = false;
        WinNT.HANDLE mutex = Kernel32.INSTANCE.CreateMutex(sa, false, this.memoryName + "_CONNECT_MUTEX");
        Kernel32.INSTANCE.LocalFree(securityDescriptor.getValue());
        if (Kernel32.INSTANCE.WaitForSingleObject(mutex, this.timeout) == -1) {
            Kernel32.INSTANCE.CloseHandle(mutex);
            throw new IOException("wait failed (timeout, last error =  " + Kernel32.INSTANCE.GetLastError());
        }
        return mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConnectNumber() throws IOException {
        int n;
        WinNT.HANDLE connectRequest;
        try {
            connectRequest = SharedMemorySocket.openEvent(this.memoryName + "_CONNECT_REQUEST");
        }
        catch (LastErrorException lee) {
            try {
                connectRequest = SharedMemorySocket.openEvent("Global\\" + this.memoryName + "_CONNECT_REQUEST");
                this.memoryName = "Global\\" + this.memoryName;
            }
            catch (LastErrorException lee2) {
                throw new IOException("getConnectNumber() fails : " + lee2.getMessage() + " " + this.memoryName);
            }
        }
        WinNT.HANDLE connectAnswer = SharedMemorySocket.openEvent(this.memoryName + "_CONNECT_ANSWER");
        WinNT.HANDLE mutex = this.lockMutex();
        Pointer connectData = null;
        try {
            Kernel32.INSTANCE.SetEvent(connectRequest);
            connectData = SharedMemorySocket.mapMemory(this.memoryName + "_CONNECT_DATA", 4, 4);
            int ret = Kernel32.INSTANCE.WaitForSingleObject(connectAnswer, this.timeout);
            if (ret != 0) {
                throw new IOException("WaitForSingleObject returned " + ret + ", last error " + Kernel32.INSTANCE.GetLastError());
            }
            n = connectData.getInt(0L);
            Kernel32.INSTANCE.ReleaseMutex(mutex);
        }
        catch (Throwable throwable) {
            Kernel32.INSTANCE.ReleaseMutex(mutex);
            Kernel32.INSTANCE.CloseHandle(mutex);
            if (connectData != null) {
                Kernel32.INSTANCE.UnmapViewOfFile(connectData);
            }
            Kernel32.INSTANCE.CloseHandle(connectRequest);
            Kernel32.INSTANCE.CloseHandle(connectAnswer);
            throw throwable;
        }
        Kernel32.INSTANCE.CloseHandle(mutex);
        if (connectData != null) {
            Kernel32.INSTANCE.UnmapViewOfFile(connectData);
        }
        Kernel32.INSTANCE.CloseHandle(connectRequest);
        Kernel32.INSTANCE.CloseHandle(connectAnswer);
        return n;
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        try {
            this.is = new SharedMemoryInputStream();
            this.os = new SharedMemoryOutputStream();
            String prefix = this.memoryName + "_" + this.getConnectNumber();
            this.clientRead = SharedMemorySocket.openEvent(prefix + "_CLIENT_READ");
            this.serverRead = SharedMemorySocket.openEvent(prefix + "_SERVER_READ");
            this.serverWrote = SharedMemorySocket.openEvent(prefix + "_SERVER_WROTE");
            this.clientWrote = SharedMemorySocket.openEvent(prefix + "_CLIENT_WROTE");
            this.connectionClosed = SharedMemorySocket.openEvent(prefix + "_CONNECTION_CLOSED");
            this.view = SharedMemorySocket.mapMemory(prefix + "_DATA", 2, 16004);
            Kernel32.INSTANCE.SetEvent(this.serverRead);
        }
        catch (LastErrorException lee) {
            throw new IOException(lee.getMessage(), lee.getCause());
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void setTcpNoDelay(boolean b) {
    }

    @Override
    public void setKeepAlive(boolean b) {
    }

    @Override
    public void setReceiveBufferSize(int size) {
    }

    @Override
    public void setSendBufferSize(int size) {
    }

    @Override
    public void setSoLinger(boolean b, int i) {
    }

    @Override
    public void setSoTimeout(int t) {
        this.timeout = t == 0 ? -1 : t;
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    @Override
    public void close() {
        WinNT.HANDLE[] handles;
        if (this.connectionClosed != null && Kernel32.INSTANCE.WaitForSingleObject(this.connectionClosed, 0) != 0) {
            Kernel32.INSTANCE.SetEvent(this.connectionClosed);
        }
        for (WinNT.HANDLE h : handles = new WinNT.HANDLE[]{this.serverRead, this.serverWrote, this.clientRead, this.clientWrote, this.connectionClosed}) {
            if (h == null) continue;
            Kernel32.INSTANCE.CloseHandle(h);
        }
        if (this.view != null) {
            Kernel32.INSTANCE.UnmapViewOfFile(this.view);
        }
        this.serverRead = null;
        this.serverWrote = null;
        this.clientRead = null;
        this.clientWrote = null;
        this.connectionClosed = null;
        this.view = null;
    }

    static /* synthetic */ Map access$000() {
        return WIN32API_OPTIONS;
    }

    static {
        WIN32API_OPTIONS.put("function-mapper", W32APIFunctionMapper.UNICODE);
        WIN32API_OPTIONS.put("type-mapper", W32APITypeMapper.UNICODE);
    }

    class SharedMemoryOutputStream
    extends OutputStream {
        SharedMemoryOutputStream() {
        }

        @Override
        public void write(byte[] bytes, int off, int count) throws IOException {
            int chunk;
            int buffPos = off;
            WinNT.HANDLE[] handles = new WinNT.HANDLE[]{SharedMemorySocket.this.serverRead, SharedMemorySocket.this.connectionClosed};
            for (int bytesToWrite = count; bytesToWrite > 0; bytesToWrite -= chunk) {
                int index = Kernel32.INSTANCE.WaitForMultipleObjects(2, handles, false, SharedMemorySocket.this.timeout);
                if (index == -1) {
                    throw new IOException("WaitForMultipleObjects() failed, timeout");
                }
                if (index == 1) {
                    throw new IOException("Server closed connection");
                }
                if (index != 0) {
                    throw new IOException("Unexpected return result from WaitForMultipleObjects : " + index);
                }
                chunk = Math.min(bytesToWrite, 16004);
                SharedMemorySocket.this.view.setInt(0L, chunk);
                SharedMemorySocket.this.view.write(4L, bytes, buffPos, chunk);
                buffPos += chunk;
                if (Kernel32.INSTANCE.SetEvent(SharedMemorySocket.this.clientWrote)) continue;
                throw new IOException("SetEvent failed");
            }
        }

        @Override
        public void write(int value) throws IOException {
            this.write(new byte[]{(byte)value});
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }
    }

    class SharedMemoryInputStream
    extends InputStream {
        SharedMemoryInputStream() {
        }

        @Override
        public int read(byte[] bytes, int off, int count) throws IOException {
            WinNT.HANDLE[] handles = new WinNT.HANDLE[]{SharedMemorySocket.this.serverWrote, SharedMemorySocket.this.connectionClosed};
            if (SharedMemorySocket.this.bytesLeft == 0) {
                int index = Kernel32.INSTANCE.WaitForMultipleObjects(2, handles, false, SharedMemorySocket.this.timeout);
                if (index == -1) {
                    throw new IOException("wait failed, timeout");
                }
                if (index == 1) {
                    throw new IOException("Server closed connection");
                }
                if (index != 0) {
                    throw new IOException("Unexpected return result from WaitForMultipleObjects : " + index);
                }
                SharedMemorySocket.this.bytesLeft = SharedMemorySocket.this.view.getInt(0L);
                SharedMemorySocket.this.position = 4;
            }
            int len = Math.min(count, SharedMemorySocket.this.bytesLeft);
            SharedMemorySocket.this.view.read((long)SharedMemorySocket.this.position, bytes, off, len);
            SharedMemorySocket.this.position = SharedMemorySocket.this.position + len;
            SharedMemorySocket.this.bytesLeft = SharedMemorySocket.this.bytesLeft - len;
            if (SharedMemorySocket.this.bytesLeft == 0) {
                Kernel32.INSTANCE.SetEvent(SharedMemorySocket.this.clientRead);
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            byte[] bit = new byte[1];
            int bytesRead = this.read(bit);
            if (bytesRead == 0) {
                return -1;
            }
            return bit[0] & 0xFF;
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }
    }

    public static interface Advapi32
    extends StdCallLibrary {
        public static final Advapi32 INSTANCE = (Advapi32)Native.loadLibrary((String)"advapi32", Advapi32.class, (Map)SharedMemorySocket.access$000());

        public boolean ConvertStringSecurityDescriptorToSecurityDescriptor(String var1, int var2, PointerByReference var3, IntByReference var4);

        public static class SECURITY_ATTRIBUTES
        extends Structure {
            public int nLength;
            public Pointer lpSecurityDescriptor;
            public boolean bInheritHandle;

            protected List<String> getFieldOrder() {
                return Arrays.asList("nLength", "lpSecurityDescriptor", "bInheritHandle");
            }
        }
    }

    public static interface Kernel32
    extends StdCallLibrary {
        public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary((String)"Kernel32", Kernel32.class, (Map)SharedMemorySocket.access$000());
        public static final int FILE_MAP_WRITE = 2;
        public static final int FILE_MAP_READ = 4;
        public static final int EVENT_MODIFY_STATE = 2;
        public static final int SYNCHRONIZE = 0x100000;
        public static final int INFINITE = -1;

        public WinNT.HANDLE OpenEvent(int var1, boolean var2, String var3) throws LastErrorException;

        public WinNT.HANDLE OpenFileMapping(int var1, boolean var2, String var3) throws LastErrorException;

        public Pointer MapViewOfFile(WinNT.HANDLE var1, int var2, int var3, int var4, BaseTSD.SIZE_T var5) throws LastErrorException;

        public boolean UnmapViewOfFile(Pointer var1) throws LastErrorException;

        public boolean SetEvent(WinNT.HANDLE var1) throws LastErrorException;

        public boolean CloseHandle(WinNT.HANDLE var1) throws LastErrorException;

        public int WaitForSingleObject(WinNT.HANDLE var1, int var2) throws LastErrorException;

        public int WaitForMultipleObjects(int var1, WinNT.HANDLE[] var2, boolean var3, int var4) throws LastErrorException;

        public int GetLastError() throws LastErrorException;

        public WinNT.HANDLE CreateMutex(Advapi32.SECURITY_ATTRIBUTES var1, boolean var2, String var3);

        public boolean ReleaseMutex(WinNT.HANDLE var1);

        public Pointer LocalFree(Pointer var1);
    }
}

