/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.ColumnType;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class TimeParameter
implements Cloneable,
ParameterHolder {
    private final Time time;
    private final TimeZone timeZone;
    private final boolean fractionalSeconds;

    public TimeParameter(Time time, TimeZone timeZone, boolean fractionalSeconds) {
        this.time = time;
        this.timeZone = timeZone;
        this.fractionalSeconds = fractionalSeconds;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setTimeZone(this.timeZone);
        String dateString = sdf.format(this.time);
        pos.write(39);
        pos.write(dateString.getBytes());
        int microseconds = (int)(this.time.getTime() % 1000L) * 1000;
        if (microseconds > 0 && this.fractionalSeconds) {
            pos.write(46);
            int factor = 100000;
            while (microseconds > 0) {
                int dig = microseconds / factor;
                pos.write(48 + dig);
                microseconds -= dig * factor;
                factor /= 10;
            }
        }
        pos.write(39);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return 15L;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTime(this.time);
        calendar.set(5, 1);
        if (this.fractionalSeconds) {
            pos.write(12);
            pos.write(0);
            pos.writeInt(0);
            pos.write((byte)calendar.get(11));
            pos.write((byte)calendar.get(12));
            pos.write((byte)calendar.get(13));
            pos.writeInt(calendar.get(14) * 1000);
        } else {
            pos.write(8);
            pos.write(0);
            pos.writeInt(0);
            pos.write((byte)calendar.get(11));
            pos.write((byte)calendar.get(12));
            pos.write((byte)calendar.get(13));
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.TIME;
    }

    @Override
    public String toString() {
        return this.time.toString();
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

