/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.AuthenticationPlugin;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.input.PacketInputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Utils;

public class NativePasswordPlugin
implements AuthenticationPlugin {
    private final String password;
    private final String passwordCharacterEncoding;
    private byte[] authData;

    public NativePasswordPlugin(String password, byte[] authData, String passwordCharacterEncoding) {
        this.authData = authData;
        this.password = password;
        this.passwordCharacterEncoding = passwordCharacterEncoding;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException {
        if (this.password == null || this.password.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            try {
                out.startPacket(sequence.incrementAndGet());
                byte[] seed = this.authData.length > 0 ? Arrays.copyOfRange(this.authData, 0, this.authData.length - 1) : new byte[]{};
                out.write(Utils.encryptPassword(this.password, seed, this.passwordCharacterEncoding));
                out.flush();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not use SHA-1, failing", e);
            }
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }
}

