/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.authentication.AuthenticationPlugin;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.input.PacketInputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class ClearPasswordPlugin
implements AuthenticationPlugin {
    private final String password;
    private final String passwordCharacterEncoding;

    public ClearPasswordPlugin(String password, String passwordCharacterEncoding) {
        this.password = password;
        this.passwordCharacterEncoding = passwordCharacterEncoding;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException {
        if (this.password == null || this.password.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            out.startPacket(sequence.incrementAndGet());
            byte[] bytePwd = this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty() ? this.password.getBytes(this.passwordCharacterEncoding) : this.password.getBytes();
            out.write(bytePwd);
            out.write(0);
            out.flush();
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }
}

