/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class ColumnNameMap {
    private final ColumnInformation[] columnInfo;
    private Map<String, Integer> originalMap;
    private Map<String, Integer> aliasMap;

    public ColumnNameMap(ColumnInformation[] columnInformations) {
        this.columnInfo = columnInformations;
    }

    public int getIndex(String name) throws SQLException {
        Integer res;
        if (name == null) {
            throw new SQLException("Column name cannot be null");
        }
        String lowerName = name.toLowerCase(Locale.ROOT);
        if (this.aliasMap == null) {
            this.aliasMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String columnAlias = ci.getName();
                if (columnAlias != null) {
                    columnAlias = columnAlias.toLowerCase(Locale.ROOT);
                    this.aliasMap.putIfAbsent(columnAlias, counter);
                    String tableName = ci.getTable();
                    if (tableName != null) {
                        this.aliasMap.putIfAbsent(tableName.toLowerCase(Locale.ROOT) + "." + columnAlias, counter);
                    }
                }
                ++counter;
            }
        }
        if ((res = this.aliasMap.get(lowerName)) != null) {
            return res;
        }
        if (this.originalMap == null) {
            this.originalMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String columnRealName = ci.getOriginalName();
                if (columnRealName != null) {
                    columnRealName = columnRealName.toLowerCase(Locale.ROOT);
                    this.originalMap.putIfAbsent(columnRealName, counter);
                    String tableName = ci.getOriginalTable();
                    if (tableName != null) {
                        this.originalMap.putIfAbsent(tableName.toLowerCase(Locale.ROOT) + "." + columnRealName, counter);
                    }
                }
                ++counter;
            }
        }
        if ((res = this.originalMap.get(lowerName)) == null) {
            throw ExceptionMapper.get("No such column: " + name, "42S22", 1054, null, false);
        }
        return res;
    }
}

