/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read;

import java.nio.charset.StandardCharsets;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.Buffer;

public class ErrorPacket {
    private static final String GENERAL_ERROR = "HY000";
    private final short errorNumber;
    private final byte sqlStateMarker;
    private final String sqlState;
    private final String message;

    public ErrorPacket(Buffer buffer) {
        buffer.skipByte();
        this.errorNumber = buffer.readShort();
        this.sqlStateMarker = buffer.readByte();
        if (this.sqlStateMarker == 35) {
            this.sqlState = buffer.readString(5);
            this.message = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        } else {
            --buffer.position;
            this.message = new String(buffer.buf, buffer.position, buffer.limit - buffer.position, StandardCharsets.UTF_8);
            this.sqlState = GENERAL_ERROR;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public short getErrorNumber() {
        return this.errorNumber;
    }

    public String getSqlState() {
        return new String(this.sqlState);
    }

    public byte getSqlStateMarker() {
        return this.sqlStateMarker;
    }
}

