/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.ColumnType;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Options;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class MariaDbResultSetMetaData
implements ResultSetMetaData {
    private final ColumnInformation[] fieldPackets;
    private final Options options;
    private final boolean returnTableAlias;

    public MariaDbResultSetMetaData(ColumnInformation[] fieldPackets, Options options, boolean returnTableAlias) {
        this.fieldPackets = fieldPackets;
        this.options = options;
        this.returnTableAlias = returnTableAlias;
    }

    @Override
    public int getColumnCount() {
        return this.fieldPackets.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return (this.getColumnInformation(column).getFlags() & 0x200) != 0;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return (this.getColumnInformation(column).getFlags() & 0x80) != 0;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if ((this.getColumnInformation(column).getFlags() & 1) == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnInformation(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumnInformation(column).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnInformation(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        String columnName = this.getColumnInformation(column).getOriginalName();
        if (this.returnTableAlias) {
            columnName = this.getColumnInformation(column).getName();
        }
        if ("".equals(columnName)) {
            columnName = this.getColumnLabel(column);
        }
        return columnName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumnInformation(column).getDatabase();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return (int)this.getColumnInformation(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInformation(column).getDecimals();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.returnTableAlias) {
            return this.getColumnInformation(column).getTable();
        }
        return this.getColumnInformation(column).getOriginalTable();
    }

    @Override
    public String getSchemaName(int column) {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        switch (ci.getColumnType()) {
            case BIT: {
                if (ci.getLength() == 1L) {
                    return -7;
                }
                return -3;
            }
            case TINYINT: {
                if (ci.getLength() == 1L && this.options.tinyInt1isBit) {
                    return -7;
                }
                return -6;
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    return 91;
                }
                return 5;
            }
            case BLOB: {
                if (ci.getLength() < 0L || ci.getLength() > 0xFFFFFFL) {
                    return -4;
                }
                return -3;
            }
            case VARCHAR: 
            case VARSTRING: {
                if (ci.isBinary()) {
                    return -3;
                }
                if (ci.getLength() < 0L) {
                    return -1;
                }
                return 12;
            }
            case STRING: {
                if (ci.isBinary()) {
                    return -2;
                }
                return 1;
            }
        }
        return ci.getColumnType().getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        return ColumnType.getColumnTypeName(ci.getColumnType(), ci.getLength(), ci.isSigned(), ci.isBinary());
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return !this.isReadOnly(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ColumnInformation ci = this.getColumnInformation(column);
        ColumnType type = ci.getColumnType();
        return ColumnType.getClassName(type, (int)ci.getLength(), ci.isSigned(), ci.isBinary(), this.options);
    }

    private ColumnInformation getColumnInformation(int column) throws SQLException {
        if (column >= 1 && column <= this.fieldPackets.length) {
            return this.fieldPackets[column - 1];
        }
        throw ExceptionMapper.getSqlException("No such column");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + iface.getName());
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

