/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.sql.external.mariadb.jdbc.BasePrepareStatement;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbConnection;
import me.lucko.helper.sql.external.mariadb.jdbc.MariaDbParameterMetaData;
import me.lucko.helper.sql.external.mariadb.jdbc.ServerSidePreparedStatement;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao.Results;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.Logger;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.logging.LoggerFactory;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class ClientSidePreparedStatement
extends BasePrepareStatement {
    private static final Logger logger = LoggerFactory.getLogger(ClientSidePreparedStatement.class);
    private final List<ParameterHolder[]> parameterList = new ArrayList<ParameterHolder[]>();
    private ClientPrepareResult prepareResult;
    private String sqlQuery;
    private ParameterHolder[] parameters;
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public ClientSidePreparedStatement(MariaDbConnection connection, String sql, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys) throws SQLException {
        super(connection, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys);
        this.sqlQuery = sql;
        this.prepareResult = this.options.rewriteBatchedStatements ? ClientPrepareResult.rewritableParts(this.sqlQuery, this.protocol.noBackslashEscapes()) : ClientPrepareResult.parameterParts(this.sqlQuery, this.protocol.noBackslashEscapes());
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public ClientSidePreparedStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        ClientSidePreparedStatement clone = (ClientSidePreparedStatement)super.clone(connection);
        clone.sqlQuery = this.sqlQuery;
        clone.prepareResult = this.prepareResult;
        clone.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        return clone;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(this.getFetchSize());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    protected boolean executeInternal(int fetchSize) throws SQLException {
        int i;
        for (i = 0; i < this.prepareResult.getParamCount(); ++i) {
            if (this.parameters[i] != null) continue;
            logger.error("Parameter at position {} is not set", (Object)(i + 1));
            ExceptionMapper.throwException(new SQLException("Parameter at position " + (i + 1) + " is not set", "07004"), this.connection, this);
        }
        this.lock.lock();
        try {
            this.executeQueryPrologue(false);
            this.results = new Results(this, fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement());
            if (this.queryTimeout != 0 && this.canUseServerTimeout) {
                this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameters, this.queryTimeout);
            } else {
                this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameters);
            }
            this.results.commandEnd();
            i = this.results.getResultSet() != null ? 1 : 0;
            return i != 0;
        }
        catch (SQLException exception) {
            if (this.results != null) {
                this.results.commandEnd();
            }
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        ParameterHolder[] holder = new ParameterHolder[this.prepareResult.getParamCount()];
        for (int i = 0; i < holder.length; ++i) {
            holder[i] = this.parameters[i];
            if (holder[i] != null) continue;
            logger.error("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.parameterList.add(holder);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.parameterList.clear();
        this.hasLongData = false;
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new int[0];
        }
        this.lock.lock();
        try {
            this.executeInternalBatch(size);
            this.results.commandEnd();
            int[] nArray = this.results.getCmdInformation().getUpdateCounts();
            return nArray;
        }
        catch (SQLException sqle) {
            throw this.executeBatchExceptionEpilogue(sqle, size);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    public int[] getServerUpdateCounts() {
        if (this.results != null && this.results.getCmdInformation() != null) {
            return this.results.getCmdInformation().getServerUpdateCounts();
        }
        return new int[0];
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new long[0];
        }
        this.lock.lock();
        try {
            this.executeInternalBatch(size);
            this.results.commandEnd();
            long[] lArray = this.results.getCmdInformation().getLargeUpdateCounts();
            return lArray;
        }
        catch (SQLException sqle) {
            throw this.executeBatchExceptionEpilogue(sqle, size);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    private void executeInternalBatch(int size) throws SQLException {
        this.executeQueryPrologue(true);
        this.results = new Results(this, 0, true, size, false, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement());
        if (this.protocol.executeBatchClient(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList, this.hasLongData)) {
            return;
        }
        SQLException exception = null;
        if (this.queryTimeout > 0) {
            for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                this.protocol.stopIfInterrupted();
                try {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList.get(batchQueriesCount));
                    continue;
                }
                catch (SQLException e) {
                    if (this.options.continueBatchOnError) {
                        exception = e;
                        continue;
                    }
                    throw e;
                }
            }
        } else {
            for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                try {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList.get(batchQueriesCount));
                    continue;
                }
                catch (SQLException e) {
                    if (this.options.continueBatchOnError) {
                        exception = e;
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.loadParametersData();
        }
        return this.resultSetMetaData;
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.prepareResult.getParamCount() + 1) {
            String error = "Could not set parameter at position " + parameterIndex + " (values was " + holder.toString() + ")\nQuery - conn:" + this.protocol.getServerThreadId() + "(" + (this.protocol.isMasterConnection() ? "M" : "S") + ") ";
            if (this.options.maxQuerySizeToLog > 0) {
                error = error + " - \"";
                error = this.sqlQuery.length() < this.options.maxQuerySizeToLog ? error + this.sqlQuery : error + this.sqlQuery.substring(0, this.options.maxQuerySizeToLog) + "...";
                error = error + "\"";
            } else {
                error = error + " - \"" + this.sqlQuery + "\"";
            }
            logger.error(error);
            throw ExceptionMapper.getSqlException(error);
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.loadParametersData();
        }
        return this.parameterMetaData;
    }

    private void loadParametersData() throws SQLSyntaxErrorException {
        try (ServerSidePreparedStatement ssps = new ServerSidePreparedStatement(this.connection, this.sqlQuery, 1004, 1007, 2);){
            this.resultSetMetaData = ssps.getMetaData();
            this.parameterMetaData = ssps.getParameterMetaData();
        }
        catch (SQLSyntaxErrorException sqlSyntaxErrorException) {
            throw sqlSyntaxErrorException;
        }
        catch (SQLException sqle) {
            this.parameterMetaData = new MariaDbParameterMetaData(null);
        }
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.noStmtEventListeners()) {
            return;
        }
        this.connection.pooledConnection.fireStatementClosed(this);
        this.connection = null;
    }

    protected int getParameterCount() {
        return this.prepareResult.getParamCount();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("sql : '" + this.sqlQuery + "'");
        sb.append(", parameters : [");
        for (int i = 0; i < this.parameters.length; ++i) {
            ParameterHolder holder = this.parameters[i];
            if (holder == null) {
                sb.append("null");
            } else {
                sb.append(holder.toString());
            }
            if (i == this.parameters.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    protected ClientPrepareResult getPrepareResult() {
        return this.prepareResult;
    }
}

