/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.hikari.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.sql.external.hikari.metrics.IMetricsTracker;

class PrometheusMetricsTracker
implements IMetricsTracker {
    private final Counter CONNECTION_TIMEOUT_COUNTER = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("hikaricp_connection_timeout_total")).labelNames(new String[]{"pool"})).help("Connection timeout total count")).create();
    private final Summary ELAPSED_ACQUIRED_SUMMARY = this.registerSummary("hikaricp_connection_acquired_nanos", "Connection acquired time (ns)");
    private final Summary ELAPSED_BORROWED_SUMMARY = this.registerSummary("hikaricp_connection_usage_millis", "Connection usage (ms)");
    private final Summary ELAPSED_CREATION_SUMMARY = this.registerSummary("hikaricp_connection_creation_millis", "Connection creation (ms)");
    private final Counter.Child connectionTimeoutCounterChild;
    private final Summary.Child elapsedAcquiredSummaryChild;
    private final Summary.Child elapsedBorrowedSummaryChild;
    private final Summary.Child elapsedCreationSummaryChild;

    private Summary registerSummary(String name, String help) {
        return ((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(name)).labelNames(new String[]{"pool"})).help(help)).quantile(0.5, 0.05).quantile(0.95, 0.01).quantile(0.99, 0.001).maxAgeSeconds(TimeUnit.MINUTES.toSeconds(5L)).ageBuckets(5).create();
    }

    PrometheusMetricsTracker(String poolName, CollectorRegistry collectorRegistry) {
        this.registerMetrics(collectorRegistry);
        this.connectionTimeoutCounterChild = (Counter.Child)this.CONNECTION_TIMEOUT_COUNTER.labels(new String[]{poolName});
        this.elapsedAcquiredSummaryChild = (Summary.Child)this.ELAPSED_ACQUIRED_SUMMARY.labels(new String[]{poolName});
        this.elapsedBorrowedSummaryChild = (Summary.Child)this.ELAPSED_BORROWED_SUMMARY.labels(new String[]{poolName});
        this.elapsedCreationSummaryChild = (Summary.Child)this.ELAPSED_CREATION_SUMMARY.labels(new String[]{poolName});
    }

    private void registerMetrics(CollectorRegistry collectorRegistry) {
        this.CONNECTION_TIMEOUT_COUNTER.register(collectorRegistry);
        this.ELAPSED_ACQUIRED_SUMMARY.register(collectorRegistry);
        this.ELAPSED_BORROWED_SUMMARY.register(collectorRegistry);
        this.ELAPSED_CREATION_SUMMARY.register(collectorRegistry);
    }

    @Override
    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.elapsedAcquiredSummaryChild.observe((double)elapsedAcquiredNanos);
    }

    @Override
    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.elapsedBorrowedSummaryChild.observe((double)elapsedBorrowedMillis);
    }

    @Override
    public void recordConnectionCreatedMillis(long connectionCreatedMillis) {
        this.elapsedCreationSummaryChild.observe((double)connectionCreatedMillis);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutCounterChild.inc();
    }
}

